/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.dto.TabelaValorCalculoParametrosDTO;
import br.com.elotech.tributos.calculo.dto.TabelaValorDTO;
import br.com.elotech.tributos.calculo.exception.TabelaValorException;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import java.io.Serializable;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tabela-valor"})
public class TabelaValorResource {
    private TabelaValorService tabelaValorService;

    public TabelaValorResource(TabelaValorService tabelaValorService) {
        this.tabelaValorService = tabelaValorService;
    }

    @PostMapping
    public ResponseEntity<TabelaValorDTO> save(@RequestBody @Valid TabelaValorDTO dto) {
        return ResponseEntity.ok((Object)this.tabelaValorService.save(dto));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TabelaValorDTO> update(@PathVariable Long id, @RequestBody @Valid TabelaValorDTO dto) {
        return ResponseEntity.ok((Object)this.tabelaValorService.update(id, dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        this.tabelaValorService.delete(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TabelaValorDTO> findById(@PathVariable Long id) {
        Optional tabelaValor = this.tabelaValorService.findById((Serializable)id);
        return ResponseEntity.ok((Object)tabelaValor.map(TabelaValorDTO::of).orElseThrow(() -> new TabelaValorException(String.format("Tabela de Valor com id %d n\u00e3o encontrada.", id))));
    }

    @GetMapping
    public ResponseEntity<Page<TabelaValor>> findAll(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.tabelaValorService.findByRsql(search, pageable));
    }

    @PostMapping(value={"/{id}/simulacao-calculo"})
    public ResponseEntity<Double> simulaCalculoValorResultado(@PathVariable Long id, @RequestBody TabelaValorCalculoParametrosDTO dto) {
        return ResponseEntity.ok((Object)this.tabelaValorService.simulaCalculoValorResultado(id, dto));
    }

    @PostMapping(value={"/{id}/reajuste-anual"})
    public ResponseEntity<Void> toggleReajusteAnual(@PathVariable Long id) {
        this.tabelaValorService.toggleReajusteAnual(id);
        return ResponseEntity.ok().build();
    }
}

