/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressaoItem;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.ws.AisePdfService;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/itens-lote-impressao"})
public class CalculoLoteImpressaoItemResource
extends ReadOnlyResource<CalculoLoteImpressaoItem, Long> {
    private final CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;
    private final AisePdfService aisePdfService;

    public CalculoLoteImpressaoItemResource(CalculoLoteImpressaoItemService calculoLoteImpressaoItemService, AisePdfService aisePdfService) {
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
        this.aisePdfService = aisePdfService;
    }

    @Transactional
    @PostMapping(value={"/{id}/gerar-carne/{codigoModeloBloquetoSemRegistro}"})
    public ResponseEntity<ImpressaoDTO> gerarCarne(@PathVariable Long id, @PathVariable Long codigoModeloBloquetoSemRegistro) {
        CalculoLoteImpressaoItemDTO dto = this.calculoLoteImpressaoItemService.gerarCarneManual(id, codigoModeloBloquetoSemRegistro);
        return ResponseEntity.ok((Object)ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(dto.getCarne())));
    }

    @GetMapping(value={"/{id}/imprimir-carne"})
    public ResponseEntity<ImpressaoDTO> imprimirCarne(@PathVariable Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.calculoLoteImpressaoItemService.findItemById(id);
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        if (Objects.isNull(calculoCadastro.getNumeroCarne())) {
            throw new EloValidationException("Este item ainda n\u00e3o possui carn\u00ea gerado.");
        }
        return ResponseEntity.ok((Object)ImpressaoDTO.from((String)this.aisePdfService.fetchCarneComExercicio(calculoCadastro.getNumeroCarne(), calculoCadastro.getExercicioCarne())));
    }

    @Transactional
    @DeleteMapping(value={"/{id}/excluir-carne"})
    public ResponseEntity<Void> excluirCarne(@PathVariable Long id) {
        this.calculoLoteImpressaoItemService.deleteCarne(id);
        return ResponseEntity.noContent().build();
    }
}

