/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.calculo.dto.ReajusteTabelaValorAlteracaoDTO;
import br.com.elotech.tributos.calculo.repository.ReajusteValorCustomRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ReajusteValorRepositoryImpl
implements ReajusteValorCustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<ReajusteTabelaValorAlteracaoDTO> loadItensTabelaValor(Long exercicio) {
        String sql = "select tv.id, tvcl.id as idtabela, tvcl.linha as sequencia, tv.nome, tv.descricao, cast(coalesce(tvcl.valor,'0') as numeric(15,4)) as valor\nfrom tabelavalor tv\njoin tabelavalorcoluna tvc\n on tv.id = tvc.idtabelavalor\njoin tabelavalorcelula tvcl\n on tvc.id = tvcl.idtabelavalorcoluna\nand tvc.tipo = 'DOUBLE'\nand lower(tvc.descricao) = 'resultado'\nwhere tv.exercicio = :exercicio\nand tv.reajusteanual = 'S'\norder by tv.id, tvcl.id, tvcl.linha";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ReajusteTabelaValorAlteracaoDTO.class));
    }

    public void atualizarTabelaValorByReajuste(Long idReajuste, Boolean estornar) {
        String colunaValor = "valoratualizado";
        if (Boolean.TRUE.equals(estornar)) {
            colunaValor = "valor";
        }
        String sqlUpdate = "update tabelavalorcelula tvc set valor = to_char(rvi." + colunaValor + ", 'FM9999999990.0000')\nfrom tribreajustevaloritem rvi\nwhere rvi.idreajustevalor = :idReajuste\nand rvi.tipo = 'TABELA_VALOR'\nand rvi.idtabela = tvc.id";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idReajuste", (Object)idReajuste);
        this.namedParameterJdbcTemplate.update(sqlUpdate, (SqlParameterSource)parameters);
    }

    public List<ReajusteTabelaValorAlteracaoDTO> loadItensTabelaTestada(Long exercicio) {
        String sql = "select lte.idlogradourotestada as id, lte.idkey as idtabela, lte.sequencia, coalesce(lte.valorterreno,0) as valor, coalesce(lte.valorterrenoitbi,0) as valoritbi,\n       lt.cidade, lt.bairro, lt.logradouro,\n       coalesce(lt.distrito,'') as distrito, coalesce(lt.setor,'') as setor,\n       coalesce(lt.quadra,'') as quadra, coalesce(ltrch.idkey,0) as logradourotrecho\nfrom triblogradourotestadaexercicio lte\njoin triblogradourotestada lt\n on lte.idlogradourotestada = lt.idlogradourotestada\nleft join triblogradourotrecho ltrch\n on lt.logradourotrecho_idkey = ltrch.idkey\nwhere lte.exercicio = :exercicio\nand (coalesce(lte.valorterreno,0) > 0 or coalesce(lte.valorterrenoitbi,0) > 0)\norder by lt.logradouro, coalesce(lt.distrito,''),  coalesce(lt.setor,''), coalesce(lt.quadra,'')";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ReajusteTabelaValorAlteracaoDTO.class));
    }

    public void atualizarTestadasByReajuste(Long idReajuste, Boolean estornar) {
        String colunaValor1 = "valoratualizado";
        String colunaValor2 = "valoritbiatualizado";
        if (Boolean.TRUE.equals(estornar)) {
            colunaValor1 = "valor";
            colunaValor2 = "valoritbi";
        }
        String sqlUpdate = "update triblogradourotestadaexercicio lte set valorterreno = rvi." + colunaValor1 + ", valorterrenoitbi = rvi." + colunaValor2 + "\nfrom tribreajustevaloritem rvi\nwhere rvi.idreajustevalor = :idReajuste\nand rvi.tipo = 'TABELA_TESTADA'\nand rvi.idtabela = lte.idkey";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idReajuste", (Object)idReajuste);
        this.namedParameterJdbcTemplate.update(sqlUpdate, (SqlParameterSource)parameters);
    }

    public List<ReajusteTabelaValorAlteracaoDTO> loadItensTabelaTestadaGenerica(Long exercicio) {
        String sql = "select tg.idkey as id, tge.id as idtabela, coalesce(tge.valorm2) as valor, 0 as valoritbi, tg.tipocadastro, tg.cadastrogeral, tg.logradouro,\n       ci.distrito_inscricaocadastral as distrito,\n       ci.setor_inscricaocadastral as setor,\n       ci.quadra_inscricaocadastral as quadra,\n       case when coalesce(tg.principal,'N') = 'S' then 'Sim' else 'N\u00e3o' end as principal  \nfrom tribimobiliariotestadagenerica tg\njoin testadagenericaexercicio tge\n on tg.idkey = tge.testadagenerica_idkey\njoin tribcadastroimobiliario ci\n on tg.tribcadastroimobiliario_idkey = ci.tribcadastrogeral_idkey\nwhere tge.exercicio = :exercicio\nand coalesce(tge.valorm2) > 0\norder by tg.logradouro, ci.distrito_inscricaocadastral, ci.setor_inscricaocadastral, ci.quadra_inscricaocadastral, tg.cadastrogeral";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ReajusteTabelaValorAlteracaoDTO.class));
    }

    public void atualizarTestadasGenericasByReajuste(Long idReajuste, Boolean estornar) {
        String colunaValor = "valoratualizado";
        if (Boolean.TRUE.equals(estornar)) {
            colunaValor = "valor";
        }
        String sqlUpdate = "update testadagenericaexercicio tge set valorm2 = rvi." + colunaValor + "\nfrom tribreajustevaloritem rvi\nwhere rvi.idreajustevalor = :idReajuste\nand rvi.tipo = 'TABELA_TESTADA_GENERICA'\nand rvi.idtabela = tge.id";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idReajuste", (Object)idReajuste);
        this.namedParameterJdbcTemplate.update(sqlUpdate, (SqlParameterSource)parameters);
    }

    @Generated
    public ReajusteValorRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

