/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.TipoCampoDinamico;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.repository.CadastroCalculoRepositoryUtils;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoDTORowMapper;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class CadastroImobiliarioMemoriaCalculoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroImobiliarioMemoriaCalculoRepository.class);
    private static final String CADASTRO_IMOBILIARIO = "br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-memoria.sql";
    private static final String BOLETIM_TERRENO = "br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-boletim-terreno-memoria.sql";
    private static final String BOLETIM_SEGMENTO = "br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-boletim-segmento-memoria.sql";
    private static final String CADASTRO_ISENCOES = "br/com/elotech/tributos/calculo/repository/load-cadastro-isencao-memoria.sql";
    private static final String BOLETIM_LOGRADOURO = "br/com/elotech/tributos/calculo/repository/load-logradouro-testada-boletim-memoria.sql";
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CadastroImobiliarioMemoriaCalculoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<CadastroCalculoRoot<Long>> loadCadastros(String filtro, Long sequenciaSegmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, Boolean isFuncaoTotalCadastroPorSegmento) {
        Map boletimCadastrosSegmentos;
        List cadastrosImobiliarioCalculoDTO;
        StringBuilder filtroSegmento = new StringBuilder();
        filtroSegmento.append(filtro);
        if (Boolean.TRUE.equals(isFuncaoTotalCadastroPorSegmento)) {
            cadastrosImobiliarioCalculoDTO = this.cadastros(filtro, exercicio);
            boletimCadastrosSegmentos = this.loadBoletimSegmento(filtro, camposDinamicos);
        } else {
            boletimCadastrosSegmentos = null;
            cadastrosImobiliarioCalculoDTO = null;
        }
        if (Objects.nonNull(sequenciaSegmento)) {
            filtroSegmento.append(String.format(" and segmento.sequencia = %d ", sequenciaSegmento));
        }
        List cadastros = this.cadastros(filtroSegmento.toString(), exercicio);
        Map boletimSegmentoAgrupado = this.loadBoletimSegmento(filtroSegmento.toString(), camposDinamicos);
        Map boletimTerrenoAgrupado = this.loadBoletimTerreno(filtro, camposDinamicos);
        Map isencoes = this.loadIsencoes(filtro, exercicio);
        Map boletimLogradouroTestada = this.loadBoletimTestadas(filtro, camposDinamicos);
        return cadastros.stream().collect(Collectors.groupingBy(CadastroCalculoDTO::getId)).entrySet().stream().map(cadastro -> this.buildRoot(cadastro, (List)boletimTerrenoAgrupado.getOrDefault(cadastro.getKey(), new ArrayList()), boletimSegmentoAgrupado, (List)isencoes.getOrDefault(cadastro.getKey(), new ArrayList()), boletimLogradouroTestada, cadastrosImobiliarioCalculoDTO, boletimCadastrosSegmentos)).collect(Collectors.toList());
    }

    private Map<Long, List<RespostaDTO>> loadBoletimTestadas(String filtro, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String filtroCamposDinamicos = CadastroCalculoRepositoryUtils.buildFiltroCampoDinamico((TipoCampoDinamico)TipoCampoDinamico.TESTADA, camposDinamicos);
        if (StringUtils.isBlank((CharSequence)filtroCamposDinamicos)) {
            return new HashMap<Long, List<RespostaDTO>>();
        }
        String sqlBoletimLogradouroTestada = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/repository/load-logradouro-testada-boletim-memoria.sql"), filtro, filtroCamposDinamicos);
        List result = this.namedParameterJdbcTemplate.query(sqlBoletimLogradouroTestada, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(RespostaDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} boletim testada - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(RespostaDTO::getReferencia));
    }

    private Map<Long, List<CadastroIsencaoDTO>> loadIsencoes(String filtro, Long exercicio) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String sqlIsencoes = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/repository/load-cadastro-isencao-memoria.sql"), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        List result = this.namedParameterJdbcTemplate.query(sqlIsencoes, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroIsencaoDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} isencoes - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(CadastroIsencaoDTO::getIdCadastro));
    }

    private Map<Long, List<RespostaDTO>> loadBoletimSegmento(String filtro, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String filtroCamposDinamicos = CadastroCalculoRepositoryUtils.buildFiltroCampoDinamico((TipoCampoDinamico)TipoCampoDinamico.SEGMENTO, camposDinamicos);
        if (StringUtils.isBlank((CharSequence)filtroCamposDinamicos)) {
            return new HashMap<Long, List<RespostaDTO>>();
        }
        String sqlBoletimSegmento = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-boletim-segmento-memoria.sql"), filtro, filtroCamposDinamicos);
        List result = this.namedParameterJdbcTemplate.query(sqlBoletimSegmento, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(RespostaDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} boletim de segmento - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(RespostaDTO::getReferencia));
    }

    private Map<Long, List<RespostaDTO>> loadBoletimTerreno(String filtro, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String filtroCamposDinamicos = CadastroCalculoRepositoryUtils.buildFiltroCampoDinamico((TipoCampoDinamico)TipoCampoDinamico.CADASTRO, camposDinamicos);
        if (StringUtils.isBlank((CharSequence)filtroCamposDinamicos)) {
            return new HashMap<Long, List<RespostaDTO>>();
        }
        String sqlBoletimTerreno = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-boletim-terreno-memoria.sql"), filtro, filtroCamposDinamicos);
        List result = this.namedParameterJdbcTemplate.query(sqlBoletimTerreno, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(RespostaDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} boletim de terreno - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(RespostaDTO::getReferencia));
    }

    private List<CadastroImobiliarioCalculoDTO> cadastros(String filtro, Long exercicio) {
        String sql = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/repository/load-cadastro-imobiliario-memoria.sql"), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List cadastros = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new CadastroImobiliarioCalculoDTORowMapper());
        stopwatch.stop();
        LOGGER.debug("Carregando {} cadastros do banco - {} m {} s {} ms - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    private CadastroCalculoRoot<Long> buildRoot(Map.Entry<Long, List<CadastroImobiliarioCalculoDTO>> cadastros, List<RespostaDTO> respostasTerreno, Map<Long, List<RespostaDTO>> respostasSegmento, List<CadastroIsencaoDTO> isencoes, Map<Long, List<RespostaDTO>> respostasLogradouroTestada, List<CadastroImobiliarioCalculoDTO> cadastrosImobiliarioCalculoDTO, Map<Long, List<RespostaDTO>> respostasCadastroSegmentos) {
        CadastroCalculoRoot root = new CadastroCalculoRoot();
        root.setChildren(cadastros.getValue().stream().map(item -> item).collect(Collectors.toList()));
        root.setIsencoes(isencoes);
        if (!cadastros.getValue().isEmpty()) {
            root.setId((Object)cadastros.getKey());
            root.setTipoCadastro(cadastros.getValue().get(0).getTipoCadastro());
            root.setCadastroGeral(cadastros.getValue().get(0).getCadastroGeral());
            Map boletimTerreno = CadastroCalculoRepositoryUtils.parseBoletim(respostasTerreno);
            if (cadastrosImobiliarioCalculoDTO != null && cadastrosImobiliarioCalculoDTO.size() > 1) {
                root.setCadastroCalculoDTO(cadastrosImobiliarioCalculoDTO.stream().map(CadastroCalculoDTO.class::cast).collect(Collectors.toList()));
                CadastroImobiliarioMemoriaCalculoRepository.populateCadastrosSegmentos(cadastrosImobiliarioCalculoDTO, isencoes, respostasLogradouroTestada, respostasCadastroSegmentos, (Map)boletimTerreno);
            }
            cadastros.getValue().forEach(cadastro -> {
                cadastro.getCadastro().setBoletim(boletimTerreno);
                cadastro.getCadastro().setIsencoes(isencoes);
                CadastroImobiliarioMemoriaCalculoRepository.builderBoletimLogradouro((Map)respostasLogradouroTestada, (CadastroImobiliarioCalculoDTO)cadastro);
                CadastroImobiliarioMemoriaCalculoRepository.builderRespostaSegmentosCadastro((Map)respostasSegmento, (CadastroImobiliarioCalculoDTO)cadastro);
            });
        }
        return root;
    }

    public static void populateCadastrosSegmentos(List<CadastroImobiliarioCalculoDTO> cadastrosSegmentos, List<CadastroIsencaoDTO> isencoes, Map<Long, List<RespostaDTO>> respostasLogradouroTestada, Map<Long, List<RespostaDTO>> respostasSegmentoAgrupados, Map<String, RespostaDTO> boletimTerreno) {
        cadastrosSegmentos.forEach(cadastro -> {
            cadastro.getCadastro().setBoletim(boletimTerreno);
            cadastro.getCadastro().setIsencoes(isencoes);
            CadastroImobiliarioMemoriaCalculoRepository.builderBoletimLogradouro((Map)respostasLogradouroTestada, (CadastroImobiliarioCalculoDTO)cadastro);
            CadastroImobiliarioMemoriaCalculoRepository.builderRespostaSegmentosCadastro((Map)respostasSegmentoAgrupados, (CadastroImobiliarioCalculoDTO)cadastro);
        });
    }

    public static void builderBoletimLogradouro(Map<Long, List<RespostaDTO>> respostasLogradouroTestada, CadastroImobiliarioCalculoDTO cadastro) {
        if (Objects.nonNull(cadastro.getTestada())) {
            Map boletimLogradouro = CadastroCalculoRepositoryUtils.parseBoletim((List)respostasLogradouroTestada.getOrDefault(cadastro.getTestada().getIdlogradourotestada(), new ArrayList()));
            cadastro.getTestada().setBoletim(boletimLogradouro);
        }
    }

    public static void builderRespostaSegmentosCadastro(Map<Long, List<RespostaDTO>> respostasSegmentoAgrupados, CadastroImobiliarioCalculoDTO cadastro) {
        Optional.ofNullable(cadastro.getSegmento()).ifPresent(segmento -> {
            Map boletimSegmento = CadastroCalculoRepositoryUtils.parseBoletim((List)respostasSegmentoAgrupados.getOrDefault(segmento.getIdsegmento(), new ArrayList()));
            segmento.setBoletim(boletimSegmento);
        });
    }
}

