/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.helpers;

import br.com.elotech.tributos.calculo.annotations.AutoCompleteDetail;
import br.com.elotech.tributos.calculo.annotations.AutoCompleteParameter;
import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.dto.FuncaoDetalheDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuxiliaresCalculoHelper {
    public static List<CampoDetalheDTO> extractCampoDetalheDTO(Map<Class<?>, CampoDetalheDTO.OrigemCampoDetalhe> inputs) {
        ArrayList<CampoDetalheDTO> response = new ArrayList<CampoDetalheDTO>();
        inputs.forEach((clazz, origem) -> response.addAll(AuxiliaresCalculoHelper.extractCampos((Class)clazz, (CampoDetalheDTO.OrigemCampoDetalhe)origem)));
        return response;
    }

    public static List<CampoDetalheDTO> extractCampos(Class<?> classToExtract, CampoDetalheDTO.OrigemCampoDetalhe origem) {
        return Stream.of(classToExtract.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AutoCompleteDetail.class)).map(field -> {
            AutoCompleteDetail annotation = field.getAnnotation(AutoCompleteDetail.class);
            return new CampoDetalheDTO(field.getName(), annotation.label(), origem, AuxiliaresCalculoHelper.parseClass(field.getType()));
        }).sorted(Comparator.comparing(CampoDetalheDTO::getOrigem).thenComparing(CampoDetalheDTO::getNome)).collect(Collectors.toList());
    }

    private static TipoCampo parseClass(Class<?> type) {
        return Map.of(Long.class, TipoCampo.INTEIRO, Double.class, TipoCampo.DECIMAL).getOrDefault(type, TipoCampo.TEXTO);
    }

    public static List<FuncaoDetalheDTO> extractFuncaoDetalheDTO(Class<?> calculoContext) {
        return Stream.of(calculoContext.getDeclaredMethods()).filter(field -> field.isAnnotationPresent(AutoCompleteDetail.class)).map(method -> {
            if (Stream.of(method.getParameters()).anyMatch(parameter -> !parameter.isAnnotationPresent(AutoCompleteParameter.class))) {
                throw new CalculoException(String.format("O m\u00e9todo %s possui par\u00e2metros sem a anota\u00e7\u00e3o @AutoCompleteParameter", method.getName()));
            }
            AutoCompleteDetail annotation = method.getAnnotation(AutoCompleteDetail.class);
            FuncaoDetalheDTO detail = new FuncaoDetalheDTO();
            detail.setNome(method.getName());
            detail.setDescricao(annotation.label());
            detail.setNumeroParametros(Integer.valueOf(method.getParameterCount()));
            String nomeParametros = Stream.of(method.getParameters()).map(parameter -> {
                AutoCompleteParameter parameterAnnotation = parameter.getAnnotation(AutoCompleteParameter.class);
                return parameterAnnotation.value();
            }).collect(Collectors.joining(", "));
            detail.setNomeParametros(nomeParametros);
            return detail;
        }).sorted(Comparator.comparing(FuncaoDetalheDTO::getNome)).collect(Collectors.toList());
    }

    public static List<FuncaoDetalheDTO> mapToFuncaoDetalheDTO(List<TabelaValor> tabelaValor) {
        return tabelaValor.stream().map(item -> {
            FuncaoDetalheDTO detail = new FuncaoDetalheDTO();
            detail.setNome(item.getNome());
            detail.setDescricao(item.getDescricao());
            List colunasParametros = item.getColunasParametros();
            detail.setNumeroParametros(Integer.valueOf(colunasParametros.size()));
            String nomeParametros = colunasParametros.stream().map(TabelaValorColuna::getDescricao).collect(Collectors.joining(", "));
            detail.setNomeParametros(nomeParametros);
            return detail;
        }).sorted(Comparator.comparing(FuncaoDetalheDTO::getNome)).collect(Collectors.toList());
    }
}

