/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.domain.parcelamento.TipoReajusteValorItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ReajusteTabelaValorAlteracaoDTO {
    private static final Long ZERO = 0L;
    private Long id;
    private Long idTabela;
    private Long sequencia;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private String nome;
    private String descricao;
    private Long cidade;
    private Long bairro;
    private Long logradouro;
    private String distrito;
    private String setor;
    private String quadra;
    private Long logradouroTrecho;
    private String principal;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorItbi = BigDecimal.ZERO;

    public String getDescricaoCompleta(ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral, TipoReajusteValorItem tipo) {
        Map<TipoReajusteValorItem, Function> descricaoMappers = Map.of(TipoReajusteValorItem.TABELA_VALOR, this.getDescricaoCompletaTabelaValor(), TipoReajusteValorItem.TABELA_TESTADA, this.getDescricaoCompletaTabelaTestada(), TipoReajusteValorItem.TABELA_TESTADA_GENERICA, this.getDescricaoCompletaTabelaTestadaGenerica());
        return (String)descricaoMappers.get(tipo).apply(configuracaoInscricaoCadastral);
    }

    private Function<ConfiguracaoInscricaoCadastral, String> getDescricaoCompletaTabelaValor() {
        return config -> {
            ArrayList<String> desc = new ArrayList<String>();
            desc.add(String.format("%s - Sequ\u00eancia: %d", this.nome, this.sequencia));
            return String.join((CharSequence)" - ", desc);
        };
    }

    private Function<ConfiguracaoInscricaoCadastral, String> getDescricaoCompletaTabelaTestada() {
        return config -> {
            ArrayList<String> desc = new ArrayList<String>();
            if (ZERO.compareTo(this.logradouro) != 0) {
                desc.add(String.format("Logradouro: %d", this.logradouro));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.distrito})) {
                desc.add(String.format("%s: %s", config.getDistrito().getDescricao(), this.distrito));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.setor})) {
                desc.add(String.format("%s: %s", config.getSetor().getDescricao(), this.setor));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.quadra})) {
                desc.add(String.format("%s: %s", config.getQuadra().getDescricao(), this.quadra));
            }
            if (ZERO.compareTo(this.logradouroTrecho) != 0) {
                desc.add(String.format("Trecho: %d", this.logradouroTrecho));
            }
            return String.join((CharSequence)" - ", desc);
        };
    }

    private Function<ConfiguracaoInscricaoCadastral, String> getDescricaoCompletaTabelaTestadaGenerica() {
        return config -> {
            ArrayList<String> desc = new ArrayList<String>();
            if (ZERO.compareTo(this.logradouro) != 0) {
                desc.add(String.format("Logradouro: %d", this.logradouro));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.distrito})) {
                desc.add(String.format("%s: %s", config.getDistrito().getDescricao(), this.distrito));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.setor})) {
                desc.add(String.format("%s: %s", config.getSetor().getDescricao(), this.setor));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.quadra})) {
                desc.add(String.format("%s: %s", config.getQuadra().getDescricao(), this.quadra));
            }
            if (ZERO.compareTo(this.cadastroGeral) != 0) {
                desc.add(String.format("Cadastro: %d", this.cadastroGeral));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.principal})) {
                desc.add(String.format("Principal: %s", this.principal));
            }
            return String.join((CharSequence)" - ", desc);
        };
    }

    @Generated
    public ReajusteTabelaValorAlteracaoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdTabela() {
        return this.idTabela;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getCidade() {
        return this.cidade;
    }

    @Generated
    public Long getBairro() {
        return this.bairro;
    }

    @Generated
    public Long getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getDistrito() {
        return this.distrito;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public Long getLogradouroTrecho() {
        return this.logradouroTrecho;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorItbi() {
        return this.valorItbi;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdTabela(Long idTabela) {
        this.idTabela = idTabela;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCidade(Long cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLogradouroTrecho(Long logradouroTrecho) {
        this.logradouroTrecho = logradouroTrecho;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorItbi(BigDecimal valorItbi) {
        this.valorItbi = valorItbi;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReajusteTabelaValorAlteracaoDTO)) {
            return false;
        }
        ReajusteTabelaValorAlteracaoDTO other = (ReajusteTabelaValorAlteracaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idTabela = this.getIdTabela();
        Long other$idTabela = other.getIdTabela();
        if (this$idTabela == null ? other$idTabela != null : !((Object)this$idTabela).equals(other$idTabela)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$cidade = this.getCidade();
        Long other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !((Object)this$cidade).equals(other$cidade)) {
            return false;
        }
        Long this$bairro = this.getBairro();
        Long other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !((Object)this$bairro).equals(other$bairro)) {
            return false;
        }
        Long this$logradouro = this.getLogradouro();
        Long other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !((Object)this$logradouro).equals(other$logradouro)) {
            return false;
        }
        Long this$logradouroTrecho = this.getLogradouroTrecho();
        Long other$logradouroTrecho = other.getLogradouroTrecho();
        if (this$logradouroTrecho == null ? other$logradouroTrecho != null : !((Object)this$logradouroTrecho).equals(other$logradouroTrecho)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$distrito = this.getDistrito();
        String other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorItbi = this.getValorItbi();
        BigDecimal other$valorItbi = other.getValorItbi();
        return !(this$valorItbi == null ? other$valorItbi != null : !((Object)this$valorItbi).equals(other$valorItbi));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReajusteTabelaValorAlteracaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idTabela = this.getIdTabela();
        result = result * 59 + ($idTabela == null ? 43 : ((Object)$idTabela).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : ((Object)$cidade).hashCode());
        Long $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : ((Object)$bairro).hashCode());
        Long $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : ((Object)$logradouro).hashCode());
        Long $logradouroTrecho = this.getLogradouroTrecho();
        result = result * 59 + ($logradouroTrecho == null ? 43 : ((Object)$logradouroTrecho).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorItbi = this.getValorItbi();
        result = result * 59 + ($valorItbi == null ? 43 : ((Object)$valorItbi).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReajusteTabelaValorAlteracaoDTO(id=" + this.getId() + ", idTabela=" + this.getIdTabela() + ", sequencia=" + this.getSequencia() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", nome=" + this.getNome() + ", descricao=" + this.getDescricao() + ", cidade=" + this.getCidade() + ", bairro=" + this.getBairro() + ", logradouro=" + this.getLogradouro() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", logradouroTrecho=" + this.getLogradouroTrecho() + ", principal=" + this.getPrincipal() + ", valor=" + String.valueOf(this.getValor()) + ", valorItbi=" + String.valueOf(this.getValorItbi()) + ")";
    }
}

