/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import java.util.Objects;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CampoDetalheDTO {
    private String nome;
    private String descricao;
    private OrigemCampoDetalhe origem;
    private TipoCampo tipo;
    private String tabela;
    private String aliasCampo;
    private Long idCampoDinamico;
    private Boolean armazenaResultadoCalculo;

    public CampoDetalheDTO(String nome, String descricao, FuncionalidadeCampo funcionalidade, TipoCampo tipo, Boolean armazenaResultadoCalculo) {
        this.nome = nome;
        this.descricao = descricao;
        this.origem = OrigemCampoDetalhe.from((FuncionalidadeCampo)funcionalidade);
        this.tipo = tipo;
        this.armazenaResultadoCalculo = armazenaResultadoCalculo;
    }

    public CampoDetalheDTO(String nome, String descricao, OrigemCampoDetalhe origem, TipoCampo tipo) {
        this.nome = nome;
        this.descricao = descricao;
        this.origem = origem;
        this.tipo = tipo;
    }

    public CampoDetalheDTO(String nome, String descricao, TipoCampo tipo, String tabela) {
        this.nome = nome;
        this.descricao = descricao;
        this.tipo = tipo;
        this.tabela = tabela;
        this.aliasCampo = nome;
    }

    public CampoDetalheDTO(String identificador, String descricao, FuncionalidadeCampo funcionalidade, TipoCampo tipo, Long idCampoDinamico, Boolean armazenaResultadoCalculo) {
        this.nome = identificador;
        this.descricao = descricao;
        this.origem = OrigemCampoDetalhe.from((FuncionalidadeCampo)funcionalidade);
        this.tipo = tipo;
        this.tabela = funcionalidade.getTabelaResposta();
        this.aliasCampo = identificador;
        this.idCampoDinamico = idCampoDinamico;
        this.armazenaResultadoCalculo = armazenaResultadoCalculo;
    }

    public CampoDetalheDTO() {
    }

    public String generateSelect() {
        if (Objects.nonNull(this.idCampoDinamico)) {
            return this.generateSelectCampoTabelaDinamica().toUpperCase();
        }
        return this.generateSelectCampoTabela().toUpperCase();
    }

    private String generateSelectCampoTabela() {
        return String.format("%s.%s", this.tabela, this.nome);
    }

    private String generateSelectCampoTabelaDinamica() {
        return String.format("(%s)", this.generateSelectCampoDinamico());
    }

    public String generateSelectCampoDinamico() {
        return String.format("%s %s %s", this.generateSelectStatement(), this.generateFromStatement(), this.generateWhereStatement());
    }

    private String generateSelectStatement() {
        if (TipoCampo.INTEIRO.equals((Object)this.getTipo())) {
            return String.format("SELECT CAST(%s.VALOR as NUMERIC(10))", this.getTabela());
        }
        if (TipoCampo.DECIMAL.equals((Object)this.getTipo())) {
            return String.format("SELECT CAST(%s.VALOR as NUMERIC(15,2))", this.getTabela());
        }
        if (TipoCampo.DATA.equals((Object)this.getTipo())) {
            return String.format("SELECT TO_DATE(%s.VALOR, 'YYYY-MM-DD')", this.getTabela());
        }
        if (TipoCampo.MULTIPLA_ESCOLHA.equals((Object)this.getTipo())) {
            return "SELECT ALTERNATIVA.CODIGO";
        }
        return String.format("SELECT UPPER(%s.VALOR)", this.getTabela());
    }

    private String generateFromStatement() {
        StringBuilder from = new StringBuilder();
        from.append(String.format("FROM %s %s", this.getTabela(), this.getTabela()));
        if (TipoCampo.MULTIPLA_ESCOLHA.equals((Object)this.getTipo())) {
            from.append(String.format(" JOIN ALTERNATIVA ALTERNATIVA ON %s.IDALTERNATIVA = ALTERNATIVA.ID", this.getTabela()));
        }
        return from.toString();
    }

    private String generateWhereStatement() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.getIdCampoDinamico())) {
            if (OrigemCampoDetalhe.CADASTRO.equals((Object)this.getOrigem())) {
                where.append(String.format("WHERE %s.REFERENCIA = TRIBCADASTROGERAL.IDKEY ", this.getTabela()));
            }
            if (OrigemCampoDetalhe.SEGMENTO.equals((Object)this.getOrigem())) {
                where.append(String.format("WHERE %s.REFERENCIA = TRIBIMOBILIARIOSEGMENTO.IDKEY ", this.getTabela()));
            }
            if (OrigemCampoDetalhe.TESTADA.equals((Object)this.getOrigem())) {
                where.append(String.format("WHERE %s.REFERENCIA = TRIBLOGRADOUROTESTADA.IDLOGRADOUROTESTADA ", this.getTabela()));
            }
            where.append(String.format("AND %s.IDCAMPO = %d", this.getTabela(), this.getIdCampoDinamico()));
        }
        return where.toString();
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public OrigemCampoDetalhe getOrigem() {
        return this.origem;
    }

    @Generated
    public TipoCampo getTipo() {
        return this.tipo;
    }

    @Generated
    public String getTabela() {
        return this.tabela;
    }

    @Generated
    public String getAliasCampo() {
        return this.aliasCampo;
    }

    @Generated
    public Long getIdCampoDinamico() {
        return this.idCampoDinamico;
    }

    @Generated
    public Boolean getArmazenaResultadoCalculo() {
        return this.armazenaResultadoCalculo;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setOrigem(OrigemCampoDetalhe origem) {
        this.origem = origem;
    }

    @Generated
    public void setTipo(TipoCampo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setTabela(String tabela) {
        this.tabela = tabela;
    }

    @Generated
    public void setAliasCampo(String aliasCampo) {
        this.aliasCampo = aliasCampo;
    }

    @Generated
    public void setIdCampoDinamico(Long idCampoDinamico) {
        this.idCampoDinamico = idCampoDinamico;
    }

    @Generated
    public void setArmazenaResultadoCalculo(Boolean armazenaResultadoCalculo) {
        this.armazenaResultadoCalculo = armazenaResultadoCalculo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CampoDetalheDTO)) {
            return false;
        }
        CampoDetalheDTO other = (CampoDetalheDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCampoDinamico = this.getIdCampoDinamico();
        Long other$idCampoDinamico = other.getIdCampoDinamico();
        if (this$idCampoDinamico == null ? other$idCampoDinamico != null : !((Object)this$idCampoDinamico).equals(other$idCampoDinamico)) {
            return false;
        }
        Boolean this$armazenaResultadoCalculo = this.getArmazenaResultadoCalculo();
        Boolean other$armazenaResultadoCalculo = other.getArmazenaResultadoCalculo();
        if (this$armazenaResultadoCalculo == null ? other$armazenaResultadoCalculo != null : !((Object)this$armazenaResultadoCalculo).equals(other$armazenaResultadoCalculo)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        OrigemCampoDetalhe this$origem = this.getOrigem();
        OrigemCampoDetalhe other$origem = other.getOrigem();
        if (this$origem == null ? other$origem != null : !this$origem.equals(other$origem)) {
            return false;
        }
        TipoCampo this$tipo = this.getTipo();
        TipoCampo other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$tabela = this.getTabela();
        String other$tabela = other.getTabela();
        if (this$tabela == null ? other$tabela != null : !this$tabela.equals(other$tabela)) {
            return false;
        }
        String this$aliasCampo = this.getAliasCampo();
        String other$aliasCampo = other.getAliasCampo();
        return !(this$aliasCampo == null ? other$aliasCampo != null : !this$aliasCampo.equals(other$aliasCampo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CampoDetalheDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCampoDinamico = this.getIdCampoDinamico();
        result = result * 59 + ($idCampoDinamico == null ? 43 : ((Object)$idCampoDinamico).hashCode());
        Boolean $armazenaResultadoCalculo = this.getArmazenaResultadoCalculo();
        result = result * 59 + ($armazenaResultadoCalculo == null ? 43 : ((Object)$armazenaResultadoCalculo).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        OrigemCampoDetalhe $origem = this.getOrigem();
        result = result * 59 + ($origem == null ? 43 : $origem.hashCode());
        TipoCampo $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $tabela = this.getTabela();
        result = result * 59 + ($tabela == null ? 43 : $tabela.hashCode());
        String $aliasCampo = this.getAliasCampo();
        result = result * 59 + ($aliasCampo == null ? 43 : $aliasCampo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CampoDetalheDTO(nome=" + this.getNome() + ", descricao=" + this.getDescricao() + ", origem=" + String.valueOf(this.getOrigem()) + ", tipo=" + String.valueOf(this.getTipo()) + ", tabela=" + this.getTabela() + ", aliasCampo=" + this.getAliasCampo() + ", idCampoDinamico=" + this.getIdCampoDinamico() + ", armazenaResultadoCalculo=" + this.getArmazenaResultadoCalculo() + ")";
    }
}

