/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.VariavelDTO;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class CalculoResultadoDTO {
    private String identificadorValor;
    private String identificadorValorBase;
    private String identificadorCondicao;
    private String identificadorAliquota;
    private String identificadorValorVenalTerritorial;
    private String identificadorValorVenalPredial;
    private String identificadorValorVenalTerritorialITBI;
    private String identificadorValorVenalPredialITBI;
    private String identificadorRenuncia;
    private String identificadorIsencao;
    private Map<String, Double> cache;
    private Map<String, List<VariavelDTO>> trace;

    public Double getValor() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorValor)).orElse(0.0);
    }

    public Double getValorBase() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorValorBase)).orElse(0.0);
    }

    public Double getValorCondicao() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorCondicao)).orElse(0.0);
    }

    public Double getValorAliquota() {
        return Optional.ofNullable(this.identificadorAliquota).map(this.cache::get).orElse(0.0);
    }

    public Double getValorVenalTerritorial() {
        return this.cache.getOrDefault(this.identificadorValorVenalTerritorial, 0.0);
    }

    public Double getValorVenalPredial() {
        return this.cache.getOrDefault(this.identificadorValorVenalPredial, 0.0);
    }

    public Double getValorVenalTerritorialITBI() {
        return this.cache.getOrDefault(this.identificadorValorVenalTerritorialITBI, 0.0);
    }

    public Double getValorVenalPredialITBI() {
        return this.cache.getOrDefault(this.identificadorValorVenalPredialITBI, 0.0);
    }

    public Double getValorRenuncia() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorRenuncia)).orElse(0.0);
    }

    public Double getIsencao() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorIsencao)).orElse(0.0);
    }

    public Boolean ignoradoPorCondicaoCalculo() {
        if (StringUtils.isBlank((String)this.identificadorCondicao)) {
            return Boolean.FALSE;
        }
        Double valorCondicao = (Double)this.cache.get(this.identificadorCondicao);
        return valorCondicao.compareTo(0.0) == 0;
    }

    public static CalculoResultadoDTO from(CalculoConfigBase config, CalculoContext context) {
        CalculoResultadoDTO resultadoDTO = new CalculoResultadoDTO();
        resultadoDTO.setCache(context.cache);
        resultadoDTO.setTrace(context.trace);
        config.setIdentificadoresResultado(resultadoDTO);
        resultadoDTO.setIdentificadorValor(config.getIdentificadorResultado());
        resultadoDTO.setIdentificadorAliquota(config.getIdentificadorAliquota());
        resultadoDTO.setIdentificadorValorBase(config.getIdentificadorBaseCalculo());
        resultadoDTO.setIdentificadorCondicao(config.getIdentificadorCondicao());
        resultadoDTO.setIdentificadorRenuncia(config.getIdentificadorRenuncia());
        resultadoDTO.setIdentificadorIsencao(config.getIdentificadorIsencao());
        return resultadoDTO;
    }

    @Generated
    public CalculoResultadoDTO() {
    }

    @Generated
    public String getIdentificadorValor() {
        return this.identificadorValor;
    }

    @Generated
    public String getIdentificadorValorBase() {
        return this.identificadorValorBase;
    }

    @Generated
    public String getIdentificadorCondicao() {
        return this.identificadorCondicao;
    }

    @Generated
    public String getIdentificadorAliquota() {
        return this.identificadorAliquota;
    }

    @Generated
    public String getIdentificadorValorVenalTerritorial() {
        return this.identificadorValorVenalTerritorial;
    }

    @Generated
    public String getIdentificadorValorVenalPredial() {
        return this.identificadorValorVenalPredial;
    }

    @Generated
    public String getIdentificadorValorVenalTerritorialITBI() {
        return this.identificadorValorVenalTerritorialITBI;
    }

    @Generated
    public String getIdentificadorValorVenalPredialITBI() {
        return this.identificadorValorVenalPredialITBI;
    }

    @Generated
    public String getIdentificadorRenuncia() {
        return this.identificadorRenuncia;
    }

    @Generated
    public String getIdentificadorIsencao() {
        return this.identificadorIsencao;
    }

    @Generated
    public Map<String, Double> getCache() {
        return this.cache;
    }

    @Generated
    public Map<String, List<VariavelDTO>> getTrace() {
        return this.trace;
    }

    @Generated
    public void setIdentificadorValor(String identificadorValor) {
        this.identificadorValor = identificadorValor;
    }

    @Generated
    public void setIdentificadorValorBase(String identificadorValorBase) {
        this.identificadorValorBase = identificadorValorBase;
    }

    @Generated
    public void setIdentificadorCondicao(String identificadorCondicao) {
        this.identificadorCondicao = identificadorCondicao;
    }

    @Generated
    public void setIdentificadorAliquota(String identificadorAliquota) {
        this.identificadorAliquota = identificadorAliquota;
    }

    @Generated
    public void setIdentificadorValorVenalTerritorial(String identificadorValorVenalTerritorial) {
        this.identificadorValorVenalTerritorial = identificadorValorVenalTerritorial;
    }

    @Generated
    public void setIdentificadorValorVenalPredial(String identificadorValorVenalPredial) {
        this.identificadorValorVenalPredial = identificadorValorVenalPredial;
    }

    @Generated
    public void setIdentificadorValorVenalTerritorialITBI(String identificadorValorVenalTerritorialITBI) {
        this.identificadorValorVenalTerritorialITBI = identificadorValorVenalTerritorialITBI;
    }

    @Generated
    public void setIdentificadorValorVenalPredialITBI(String identificadorValorVenalPredialITBI) {
        this.identificadorValorVenalPredialITBI = identificadorValorVenalPredialITBI;
    }

    @Generated
    public void setIdentificadorRenuncia(String identificadorRenuncia) {
        this.identificadorRenuncia = identificadorRenuncia;
    }

    @Generated
    public void setIdentificadorIsencao(String identificadorIsencao) {
        this.identificadorIsencao = identificadorIsencao;
    }

    @Generated
    public void setCache(Map<String, Double> cache) {
        this.cache = cache;
    }

    @Generated
    public void setTrace(Map<String, List<VariavelDTO>> trace) {
        this.trace = trace;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoResultadoDTO)) {
            return false;
        }
        CalculoResultadoDTO other = (CalculoResultadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$identificadorValor = this.getIdentificadorValor();
        String other$identificadorValor = other.getIdentificadorValor();
        if (this$identificadorValor == null ? other$identificadorValor != null : !this$identificadorValor.equals(other$identificadorValor)) {
            return false;
        }
        String this$identificadorValorBase = this.getIdentificadorValorBase();
        String other$identificadorValorBase = other.getIdentificadorValorBase();
        if (this$identificadorValorBase == null ? other$identificadorValorBase != null : !this$identificadorValorBase.equals(other$identificadorValorBase)) {
            return false;
        }
        String this$identificadorCondicao = this.getIdentificadorCondicao();
        String other$identificadorCondicao = other.getIdentificadorCondicao();
        if (this$identificadorCondicao == null ? other$identificadorCondicao != null : !this$identificadorCondicao.equals(other$identificadorCondicao)) {
            return false;
        }
        String this$identificadorAliquota = this.getIdentificadorAliquota();
        String other$identificadorAliquota = other.getIdentificadorAliquota();
        if (this$identificadorAliquota == null ? other$identificadorAliquota != null : !this$identificadorAliquota.equals(other$identificadorAliquota)) {
            return false;
        }
        String this$identificadorValorVenalTerritorial = this.getIdentificadorValorVenalTerritorial();
        String other$identificadorValorVenalTerritorial = other.getIdentificadorValorVenalTerritorial();
        if (this$identificadorValorVenalTerritorial == null ? other$identificadorValorVenalTerritorial != null : !this$identificadorValorVenalTerritorial.equals(other$identificadorValorVenalTerritorial)) {
            return false;
        }
        String this$identificadorValorVenalPredial = this.getIdentificadorValorVenalPredial();
        String other$identificadorValorVenalPredial = other.getIdentificadorValorVenalPredial();
        if (this$identificadorValorVenalPredial == null ? other$identificadorValorVenalPredial != null : !this$identificadorValorVenalPredial.equals(other$identificadorValorVenalPredial)) {
            return false;
        }
        String this$identificadorValorVenalTerritorialITBI = this.getIdentificadorValorVenalTerritorialITBI();
        String other$identificadorValorVenalTerritorialITBI = other.getIdentificadorValorVenalTerritorialITBI();
        if (this$identificadorValorVenalTerritorialITBI == null ? other$identificadorValorVenalTerritorialITBI != null : !this$identificadorValorVenalTerritorialITBI.equals(other$identificadorValorVenalTerritorialITBI)) {
            return false;
        }
        String this$identificadorValorVenalPredialITBI = this.getIdentificadorValorVenalPredialITBI();
        String other$identificadorValorVenalPredialITBI = other.getIdentificadorValorVenalPredialITBI();
        if (this$identificadorValorVenalPredialITBI == null ? other$identificadorValorVenalPredialITBI != null : !this$identificadorValorVenalPredialITBI.equals(other$identificadorValorVenalPredialITBI)) {
            return false;
        }
        String this$identificadorRenuncia = this.getIdentificadorRenuncia();
        String other$identificadorRenuncia = other.getIdentificadorRenuncia();
        if (this$identificadorRenuncia == null ? other$identificadorRenuncia != null : !this$identificadorRenuncia.equals(other$identificadorRenuncia)) {
            return false;
        }
        String this$identificadorIsencao = this.getIdentificadorIsencao();
        String other$identificadorIsencao = other.getIdentificadorIsencao();
        if (this$identificadorIsencao == null ? other$identificadorIsencao != null : !this$identificadorIsencao.equals(other$identificadorIsencao)) {
            return false;
        }
        Map this$cache = this.getCache();
        Map other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        Map this$trace = this.getTrace();
        Map other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoResultadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identificadorValor = this.getIdentificadorValor();
        result = result * 59 + ($identificadorValor == null ? 43 : $identificadorValor.hashCode());
        String $identificadorValorBase = this.getIdentificadorValorBase();
        result = result * 59 + ($identificadorValorBase == null ? 43 : $identificadorValorBase.hashCode());
        String $identificadorCondicao = this.getIdentificadorCondicao();
        result = result * 59 + ($identificadorCondicao == null ? 43 : $identificadorCondicao.hashCode());
        String $identificadorAliquota = this.getIdentificadorAliquota();
        result = result * 59 + ($identificadorAliquota == null ? 43 : $identificadorAliquota.hashCode());
        String $identificadorValorVenalTerritorial = this.getIdentificadorValorVenalTerritorial();
        result = result * 59 + ($identificadorValorVenalTerritorial == null ? 43 : $identificadorValorVenalTerritorial.hashCode());
        String $identificadorValorVenalPredial = this.getIdentificadorValorVenalPredial();
        result = result * 59 + ($identificadorValorVenalPredial == null ? 43 : $identificadorValorVenalPredial.hashCode());
        String $identificadorValorVenalTerritorialITBI = this.getIdentificadorValorVenalTerritorialITBI();
        result = result * 59 + ($identificadorValorVenalTerritorialITBI == null ? 43 : $identificadorValorVenalTerritorialITBI.hashCode());
        String $identificadorValorVenalPredialITBI = this.getIdentificadorValorVenalPredialITBI();
        result = result * 59 + ($identificadorValorVenalPredialITBI == null ? 43 : $identificadorValorVenalPredialITBI.hashCode());
        String $identificadorRenuncia = this.getIdentificadorRenuncia();
        result = result * 59 + ($identificadorRenuncia == null ? 43 : $identificadorRenuncia.hashCode());
        String $identificadorIsencao = this.getIdentificadorIsencao();
        result = result * 59 + ($identificadorIsencao == null ? 43 : $identificadorIsencao.hashCode());
        Map $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        Map $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoResultadoDTO(identificadorValor=" + this.getIdentificadorValor() + ", identificadorValorBase=" + this.getIdentificadorValorBase() + ", identificadorCondicao=" + this.getIdentificadorCondicao() + ", identificadorAliquota=" + this.getIdentificadorAliquota() + ", identificadorValorVenalTerritorial=" + this.getIdentificadorValorVenalTerritorial() + ", identificadorValorVenalPredial=" + this.getIdentificadorValorVenalPredial() + ", identificadorValorVenalTerritorialITBI=" + this.getIdentificadorValorVenalTerritorialITBI() + ", identificadorValorVenalPredialITBI=" + this.getIdentificadorValorVenalPredialITBI() + ", identificadorRenuncia=" + this.getIdentificadorRenuncia() + ", identificadorIsencao=" + this.getIdentificadorIsencao() + ", cache=" + String.valueOf(this.getCache()) + ", trace=" + String.valueOf(this.getTrace()) + ")";
    }
}

