/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.annotations.AutoCompleteDetail;
import br.com.elotech.tributos.calculo.annotations.AutoCompleteParameter;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.MobiliarioAtividadeDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioCnaeDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioServicoDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculoMobiliarioContext
extends CalculoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoMobiliarioContext.class);
    public MobiliarioDTO cadastro;
    public MobiliarioAtividadeDTO atividade;
    public MobiliarioCnaeDTO cnae;
    public MobiliarioServicoDTO servico;

    @AutoCompleteDetail(label="Retorna o valor do boletim do cadastro imobili\u00e1rio associado de acordo com identificador informado")
    public String buscacampocadastrorelacionado(@AutoCompleteParameter(value="cadastro") MobiliarioDTO cadastro, @AutoCompleteParameter(value="identificador") String identificador) {
        RespostaDTO respostaDTO = cadastro.getBoletimImobiliarioAssociado().getOrDefault(identificador.toLowerCase(), new RespostaDTO());
        String valor = respostaDTO.getValor();
        if (StringUtils.isNotBlank((CharSequence)valor)) {
            this.addTrace(this.registroTraceAtual, String.format("buscacampocadastrorelacionado(cadastro, \"%s\")", identificador), (Object)valor);
            LOGGER.trace("Campo do boletim do imobili\u00e1rio associado {}, valor {}", (Object)identificador, (Object)valor);
            return valor;
        }
        if (Objects.isNull(respostaDTO.getAlternativaValor())) {
            throw new CalculoException(String.format("Campo do boletim do imobili\u00e1rio associado \"%s\" nulo", identificador));
        }
        valor = String.valueOf(respostaDTO.getAlternativaValor().intValue());
        this.addTrace(this.registroTraceAtual, String.format("buscacampocadastrorelacionado(cadastro, \"%s\")", identificador), (Object)valor);
        LOGGER.trace("Campo do boletim do imobili\u00e1rio associado {}, valor {}", (Object)identificador, (Object)valor);
        return valor;
    }

    @Generated
    public MobiliarioDTO getCadastro() {
        return this.cadastro;
    }

    @Generated
    public MobiliarioAtividadeDTO getAtividade() {
        return this.atividade;
    }

    @Generated
    public MobiliarioCnaeDTO getCnae() {
        return this.cnae;
    }

    @Generated
    public MobiliarioServicoDTO getServico() {
        return this.servico;
    }

    @Generated
    public void setCadastro(MobiliarioDTO cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public void setAtividade(MobiliarioAtividadeDTO atividade) {
        this.atividade = atividade;
    }

    @Generated
    public void setCnae(MobiliarioCnaeDTO cnae) {
        this.cnae = cnae;
    }

    @Generated
    public void setServico(MobiliarioServicoDTO servico) {
        this.servico = servico;
    }
}

