/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.annotations.AutoCompleteDetail;
import br.com.elotech.tributos.calculo.annotations.AutoCompleteParameter;
import br.com.elotech.tributos.calculo.dto.CadastroDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.dto.VariavelDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.exception.TabelaValorException;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CalculoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoContext.class);
    private static final String REGEX_DATA = "([0-9]{4})-([0-9]{2})-([0-9]{2})";
    private static final String CACHE_TOTAL_POR_CADASTRO = "buscatotalporcadastro";
    protected Integer exercicioatual = LocalDate.now().getYear();
    protected Integer exercicioCalculo;
    protected String registroTraceAtual = "";
    protected Boolean traceAtivo = Boolean.FALSE;
    protected CalculoTabelaValores calculoTabelaValores;
    protected Boolean acumula = Boolean.FALSE;
    protected Boolean aceitaCampoNulo = Boolean.FALSE;
    protected Map<String, Double> cache = new LinkedHashMap();
    protected Map<String, List<VariavelDTO>> trace = new LinkedHashMap();

    @AutoCompleteDetail(label="Retorna se o cadastro possui uma isen\u00e7\u00e3o com o c\u00f3digo informado")
    public Double existeisencao(@AutoCompleteParameter(value="cadastro") CadastroDTO cadastro, @AutoCompleteParameter(value="isencao") Long isencao) {
        return cadastro.getIsencoes().stream().filter(cadastroIsencaoDTO -> cadastroIsencaoDTO.getIsencao().equals(isencao)).findFirst().map(cadastroIsencaoDTO -> 1.0).orElse(0.0);
    }

    public Double existeisencao(CadastroDTO cadastro, Double isencao) {
        return this.existeisencao(cadastro, Long.valueOf(isencao.longValue()));
    }

    public Double existeisencao(CadastroDTO cadastro, Integer isencao) {
        return this.existeisencao(cadastro, Long.valueOf(isencao.longValue()));
    }

    public Double get(String key) {
        Double valor = (Double)this.cache.get(key);
        this.addTrace(this.registroTraceAtual, String.format("#%s", key), (Object)valor);
        LOGGER.trace("CAMPO do calculo: {}, valor: {}", (Object)key, (Object)valor);
        return valor;
    }

    public Double castExpressaoCalculoToDouble(String key, Object expressao) {
        if (expressao instanceof String) {
            try {
                String texto = (String)expressao;
                return Double.valueOf(texto.replaceAll(",", "."));
            }
            catch (NumberFormatException e) {
                throw new CalculoException(String.format("A express\u00e3o \"%s\" (%s) n\u00e3o p\u00f4de ser convertida num\u00e9rico.", expressao, key));
            }
        }
        if (expressao instanceof Boolean) {
            return (Boolean)expressao != false ? 1.0 : 0.0;
        }
        return Optional.ofNullable(expressao).map(ex -> Double.valueOf(ex.toString())).orElse(null);
    }

    public void put(String key, Double valor) {
        if (Objects.nonNull(valor) && valor.isInfinite()) {
            throw new CalculoException(String.format("Resultado da express\u00e3o \"%s\" foi \"%s\". Verifique se a fun\u00e7\u00e3o executa divis\u00e3o por zero ou se os valores s\u00e3o muito grandes.", key, valor));
        }
        this.cache.put(key, valor);
    }

    @AutoCompleteDetail(label="Retorna se o valor \u00e9 verdadeiro")
    public boolean verdadeiro(@AutoCompleteParameter(value="valor") Double valor) {
        return BigDecimal.valueOf(valor).compareTo(BigDecimal.valueOf(1L)) == 0;
    }

    @AutoCompleteDetail(label="Retorna se o valor \u00e9 falso")
    public boolean falso(@AutoCompleteParameter(value="valor") Double valor) {
        return BigDecimal.valueOf(valor).compareTo(BigDecimal.ZERO) == 0;
    }

    @AutoCompleteDetail(label="Arredonda o valor para duas casas decimais")
    public Double arredonda(@AutoCompleteParameter(value="valor") Double valor) {
        return this.arredonda(valor, Integer.valueOf(2));
    }

    @AutoCompleteDetail(label="Arredonda o valor para o n\u00famero de casas informados")
    public Double arredonda(@AutoCompleteParameter(value="valor") Double valor, @AutoCompleteParameter(value="numeroCasas") Integer casas) {
        return BigDecimal.valueOf(valor).setScale((int)casas, RoundingMode.HALF_DOWN).doubleValue();
    }

    public Double arredonda(Integer valor) {
        return this.arredonda(valor, Integer.valueOf(2));
    }

    public Double arredonda(Integer valor, Integer casas) {
        return BigDecimal.valueOf(valor.intValue()).setScale((int)casas, RoundingMode.HALF_DOWN).doubleValue();
    }

    @AutoCompleteDetail(label="Retorna o menor entre dois valores")
    public Double menorvalor(@AutoCompleteParameter(value="valor1") Double valor1, @AutoCompleteParameter(value="valor2") Double valor2) {
        return Double.min(valor1, valor2);
    }

    public Double menorvalor(Integer valor1, Integer valor2) {
        return Double.min(valor1.intValue(), valor2.intValue());
    }

    public Double menorvalor(Double valor1, Integer valor2) {
        return Double.min(valor1, valor2.intValue());
    }

    public Double menorvalor(Integer valor1, Double valor2) {
        return Double.min(valor1.intValue(), valor2);
    }

    @AutoCompleteDetail(label="Retorna a raiz quadrada do n\u00famero")
    public Double raizquadrada(@AutoCompleteParameter(value="valor") Double valor) {
        return Math.sqrt(valor);
    }

    public Double raizquadrada(Integer valor) {
        return Math.sqrt(valor.intValue());
    }

    @AutoCompleteDetail(label="Retorna o resultado da exponencia\u00e7\u00e3o entre os dois valores")
    public Double exponenciacao(@AutoCompleteParameter(value="valor") Double valor, @AutoCompleteParameter(value="exponencial") Integer exponencial) {
        return Math.pow(valor, exponencial.intValue());
    }

    public Double exponenciacao(Integer valor, Integer exponencial) {
        return Math.pow(valor.intValue(), exponencial.intValue());
    }

    public Double exponenciacao(Double valor, Double exponencial) {
        return Math.pow(valor, exponencial);
    }

    public Double exponenciacao(Integer valor, Double exponencial) {
        return Math.pow(valor.intValue(), exponencial);
    }

    @AutoCompleteDetail(label="Eleva o valor ao quadrado")
    public Double quadrado(@AutoCompleteParameter(value="valor") Double valor) {
        return this.exponenciacao(valor, Integer.valueOf(2));
    }

    public Double quadrado(Integer valor) {
        return this.exponenciacao(valor, Integer.valueOf(2));
    }

    public Double getcampocadastro(Double campo, String nomeCampo) {
        this.logCampo((Object)campo, nomeCampo);
        return campo;
    }

    public Long getcampocadastro(Long campo, String nomeCampo) {
        this.logCampo((Object)campo, nomeCampo);
        return campo;
    }

    public Integer getcampocadastro(Integer campo, String nomeCampo) {
        this.logCampo((Object)campo, nomeCampo);
        return campo;
    }

    public String getcampocadastro(String campo, String nomeCampo) {
        this.logCampo((Object)campo, nomeCampo);
        return campo;
    }

    private void logCampo(Object campo, String nomeCampo) {
        this.addTrace(this.registroTraceAtual, nomeCampo, campo);
        LOGGER.trace("CAMPO: {}, valor: {}", (Object)nomeCampo, campo);
        if (Objects.isNull(campo)) {
            LOGGER.error("CAMPO {} nulo", (Object)nomeCampo);
            if (Boolean.FALSE.equals(this.aceitaCampoNulo)) {
                throw new CalculoException(String.format("Campo %s nulo.", nomeCampo));
            }
        }
    }

    public Double tabelavalores(String nomeTabela, Object ... parametros) {
        Double valor = this.calculoTabelaValores.calculaTabelaValores(nomeTabela, parametros);
        if (Objects.isNull(valor)) {
            throw new TabelaValorException(String.format("Resultado n\u00e3o encontrado na tabela de valor \"%s\". Par\u00e2metros: \"%s\".", nomeTabela, Stream.of(parametros).map(Object::toString).collect(Collectors.joining(", "))));
        }
        this.addTrace(this.registroTraceAtual, String.format("tabelavalores(\"%s\")", nomeTabela), (Object)valor);
        return valor;
    }

    public Double campo(CadastroDTO cadastro, String identificador) {
        return Double.valueOf(this.campotexto(cadastro, identificador));
    }

    public Integer campointeiro(CadastroDTO cadastro, String identificador) {
        return Integer.valueOf(this.campotexto(cadastro, identificador));
    }

    public String campotexto(CadastroDTO cadastro, String identificador) {
        return this.campotexto(cadastro, identificador, null);
    }

    public Double campo(CadastroDTO cadastro, String identificador, Object valorDefault) {
        return Double.valueOf(this.campotexto(cadastro, identificador, valorDefault));
    }

    public Integer campointeiro(CadastroDTO cadastro, String identificador, Object valorDefault) {
        return Integer.valueOf(this.campotexto(cadastro, identificador, valorDefault));
    }

    public String campotexto(CadastroDTO cadastro, String identificador, Object valorDefault) {
        String valor = cadastro.getBoletim().getOrDefault(identificador.toLowerCase(), new RespostaDTO()).getValor();
        if (Objects.isNull(valor)) {
            if (Objects.isNull(valorDefault)) {
                throw new CalculoException(String.format("Campo do boletim \"%s\" nulo", identificador));
            }
            valor = valorDefault.toString();
        }
        this.addTrace(this.registroTraceAtual, String.format("campo(cadastro, \"%s\")", identificador), (Object)valor);
        LOGGER.trace("Campo do boletim {}, valor {}", (Object)identificador, (Object)valor);
        return valor;
    }

    public Double valoralternativa(CadastroDTO cadastro, String identificador) {
        RespostaDTO resposta = (RespostaDTO)cadastro.getBoletim().get(identificador);
        if (Objects.isNull(resposta)) {
            throw new CalculoException(String.format("Campo do boletim \"%s\" nulo", identificador));
        }
        if (Objects.isNull(resposta.getAlternativaValor())) {
            throw new CalculoException(String.format("Campo do boletim \"%s\" n\u00e3o possui valor de m\u00faltipla escolha", identificador));
        }
        this.addTrace(this.registroTraceAtual, String.format("valoralternativa(cadastro, \"%s\")", identificador), (Object)resposta.getAlternativaValor());
        LOGGER.trace("Campo do boletim {}, valor alternativa {}", (Object)identificador, (Object)resposta.getAlternativaValor());
        return resposta.getAlternativaValor();
    }

    protected void addTrace(String identificador, String variavel, Object valor) {
        if (Boolean.FALSE.equals(this.traceAtivo) || StringUtils.isBlank((CharSequence)identificador)) {
            return;
        }
        VariavelDTO variavelDTO = new VariavelDTO();
        variavelDTO.setVariavel(variavel);
        variavelDTO.setValor(valor);
        if (this.trace.containsKey(identificador)) {
            ((List)this.trace.get(identificador)).add(variavelDTO);
        } else {
            ArrayList<VariavelDTO> variaveis = new ArrayList<VariavelDTO>();
            variaveis.add(variavelDTO);
            this.trace.put(identificador, variaveis);
        }
    }

    public boolean comparestringequals(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    public boolean comparestringnotequals(String a, String b) {
        return !a.equalsIgnoreCase(b);
    }

    public boolean compareObjectEquals(Object a, Object b) {
        if (a instanceof String) {
            return this.comparestringequals(String.valueOf(a), String.valueOf(b));
        }
        return new BigDecimal(String.valueOf(a)).compareTo(new BigDecimal(String.valueOf(b))) == 0;
    }

    public boolean compareObjectNotEquals(Object a, Object b) {
        return !this.compareObjectEquals(a, b);
    }

    @AutoCompleteDetail(label="Extrai o dia da data no formato YYYY-MM-DD")
    public long extraidia(@AutoCompleteParameter(value="data") String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return 0L;
        }
        return this.extraiCampoData(data, Integer.valueOf(3));
    }

    @AutoCompleteDetail(label="Extrai o m\u00eas da data no formato YYYY-MM-DD")
    public long extraimes(@AutoCompleteParameter(value="data") String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return 0L;
        }
        return this.extraiCampoData(data, Integer.valueOf(2));
    }

    @AutoCompleteDetail(label="Extrai o ano da data no formato YYYY-MM-DD")
    public long extraiano(@AutoCompleteParameter(value="data") String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return 0L;
        }
        return this.extraiCampoData(data, Integer.valueOf(1));
    }

    private long extraiCampoData(String data, Integer campo) {
        Pattern pattern = Pattern.compile(REGEX_DATA);
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            return Long.valueOf(matcher.group(campo));
        }
        return 0L;
    }

    @AutoCompleteDetail(label="Retorna o ano atual")
    public Integer exercicioatual() {
        return this.exercicioatual;
    }

    @AutoCompleteDetail(label="Retorna o ano do c\u00e1lculo")
    public Integer exerciciocalculo() {
        return this.exercicioCalculo;
    }

    @AutoCompleteDetail(label="Retorna data em dias")
    public long data(@AutoCompleteParameter(value="data") String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return 0L;
        }
        LocalDate formattedDate = DateUtils.stringToLocalDate((String)data);
        return formattedDate.toEpochDay();
    }

    @AutoCompleteDetail(label="Retorna se o cadastro possui o valor de acordo com identificador de boletim informado")
    public boolean camponulo(@AutoCompleteParameter(value="cadastro") CadastroDTO cadastro, @AutoCompleteParameter(value="identificador") String identificador) {
        return Objects.isNull(cadastro.getBoletim().getOrDefault(identificador.toLowerCase(), new RespostaDTO()).getValor());
    }

    @AutoCompleteDetail(label="Retorna se o argumento passado \u00e9 nulo")
    public <T> boolean nulo(@AutoCompleteParameter(value="argumento") T argumento) {
        return Objects.isNull(argumento);
    }

    @AutoCompleteDetail(label="Busca valor total do cadastro por segmento")
    public Double buscatotalcadastroporsegmento(@AutoCompleteParameter(value="formula") Double formula) {
        if (Boolean.FALSE.equals(this.acumula)) {
            return this.cache.getOrDefault(CACHE_TOTAL_POR_CADASTRO, formula);
        }
        return this.getTotalPorSegmento(formula);
    }

    public Double getTotalPorSegmento(Double formula) {
        Double valorTotal = this.cache.getOrDefault(CACHE_TOTAL_POR_CADASTRO, 0.0);
        valorTotal = valorTotal + Optional.ofNullable(formula).orElse(0.0);
        this.put(CACHE_TOTAL_POR_CADASTRO, valorTotal);
        return valorTotal;
    }

    @Generated
    public Integer getExercicioatual() {
        return this.exercicioatual;
    }

    @Generated
    public Integer getExercicioCalculo() {
        return this.exercicioCalculo;
    }

    @Generated
    public String getRegistroTraceAtual() {
        return this.registroTraceAtual;
    }

    @Generated
    public Boolean getTraceAtivo() {
        return this.traceAtivo;
    }

    @Generated
    public CalculoTabelaValores getCalculoTabelaValores() {
        return this.calculoTabelaValores;
    }

    @Generated
    public Boolean getAcumula() {
        return this.acumula;
    }

    @Generated
    public Boolean getAceitaCampoNulo() {
        return this.aceitaCampoNulo;
    }

    @Generated
    public Map<String, Double> getCache() {
        return this.cache;
    }

    @Generated
    public Map<String, List<VariavelDTO>> getTrace() {
        return this.trace;
    }

    @Generated
    public void setExercicioatual(Integer exercicioatual) {
        this.exercicioatual = exercicioatual;
    }

    @Generated
    public void setRegistroTraceAtual(String registroTraceAtual) {
        this.registroTraceAtual = registroTraceAtual;
    }

    @Generated
    public void setTraceAtivo(Boolean traceAtivo) {
        this.traceAtivo = traceAtivo;
    }

    @Generated
    public void setCalculoTabelaValores(CalculoTabelaValores calculoTabelaValores) {
        this.calculoTabelaValores = calculoTabelaValores;
    }

    @Generated
    public void setAcumula(Boolean acumula) {
        this.acumula = acumula;
    }

    @Generated
    public void setAceitaCampoNulo(Boolean aceitaCampoNulo) {
        this.aceitaCampoNulo = aceitaCampoNulo;
    }

    @Generated
    public void setCache(Map<String, Double> cache) {
        this.cache = cache;
    }

    @Generated
    public void setTrace(Map<String, List<VariavelDTO>> trace) {
        this.trace = trace;
    }

    @Generated
    public void setExercicioCalculo(Integer exercicioCalculo) {
        this.exercicioCalculo = exercicioCalculo;
    }
}

