/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public abstract class CadastroCalculoDTO<K> {
    private K id;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Map<CalculoTributo, CalculoResultadoDTO> resultado = new HashMap();
    private Map<CalculoAvaliacao, CalculoResultadoDTO> resultadoAvaliacao = new HashMap();
    private Map<CalculoProjeto, CalculoResultadoDTO> resultadoCalculoProjeto = new HashMap();

    public void addResultado(CalculoConfigBase config, CalculoContext context) {
        CalculoResultadoDTO resultadoDTO = CalculoResultadoDTO.from((CalculoConfigBase)config, (CalculoContext)context);
        if (config instanceof CalculoTributo) {
            this.resultado.put((CalculoTributo)config, resultadoDTO);
        } else if (config instanceof CalculoAvaliacao) {
            this.resultadoAvaliacao.put((CalculoAvaliacao)config, resultadoDTO);
        } else if (config instanceof CalculoProjeto) {
            this.resultadoCalculoProjeto.put((CalculoProjeto)config, resultadoDTO);
        } else {
            throw new EloValidationException("Tipo de configura\u00e7\u00e3o de c\u00e1lculo n\u00e3o implementado ainda: " + config.getClass().getSimpleName());
        }
    }

    @Generated
    public CadastroCalculoDTO() {
    }

    @Generated
    public K getId() {
        return (K)this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Map<CalculoTributo, CalculoResultadoDTO> getResultado() {
        return this.resultado;
    }

    @Generated
    public Map<CalculoAvaliacao, CalculoResultadoDTO> getResultadoAvaliacao() {
        return this.resultadoAvaliacao;
    }

    @Generated
    public Map<CalculoProjeto, CalculoResultadoDTO> getResultadoCalculoProjeto() {
        return this.resultadoCalculoProjeto;
    }

    @Generated
    public void setId(K id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setResultado(Map<CalculoTributo, CalculoResultadoDTO> resultado) {
        this.resultado = resultado;
    }

    @Generated
    public void setResultadoAvaliacao(Map<CalculoAvaliacao, CalculoResultadoDTO> resultadoAvaliacao) {
        this.resultadoAvaliacao = resultadoAvaliacao;
    }

    @Generated
    public void setResultadoCalculoProjeto(Map<CalculoProjeto, CalculoResultadoDTO> resultadoCalculoProjeto) {
        this.resultadoCalculoProjeto = resultadoCalculoProjeto;
    }

    @Generated
    public String toString() {
        return "CadastroCalculoDTO(id=" + String.valueOf(this.getId()) + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", resultado=" + String.valueOf(this.getResultado()) + ", resultadoAvaliacao=" + String.valueOf(this.getResultadoAvaliacao()) + ", resultadoCalculoProjeto=" + String.valueOf(this.getResultadoCalculoProjeto()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroCalculoDTO)) {
            return false;
        }
        CadastroCalculoDTO other = (CadastroCalculoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Object this$id = this.getId();
        Object other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroCalculoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

