/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.TipoBloqueto;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class AlteracaoVencimentoParcelaDTO {
    @NotNull
    private Long parcela;
    @NotNull
    private LocalDate vencimento;
    private Boolean cotaUnica;

    public static List<AlteracaoVencimentoParcelaDTO> of(List<Bloqueto> boletos) {
        if (Objects.isNull(boletos)) {
            return null;
        }
        ArrayList<AlteracaoVencimentoParcelaDTO> result = new ArrayList<AlteracaoVencimentoParcelaDTO>();
        for (Bloqueto boleto : boletos) {
            BoletoDebito boletoDebito = (BoletoDebito)boleto.getDebitos().stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("Nenhum d\u00e9bito encontrado para o boleto com entidade %d, exerc\u00edcio %d e bloqueto %s.", boleto.getEntidade(), boleto.getExercicioBloqueto(), boleto.getBloqueto())));
            AlteracaoVencimentoParcelaDTO dto = new AlteracaoVencimentoParcelaDTO();
            dto.setParcela(boletoDebito.getId().getDebitoParcelaTributo().getParcela());
            dto.setVencimento(boleto.getDataVencimento());
            dto.setCotaUnica(Boolean.valueOf(TipoBloqueto.COTA_UNICA.equals((Object)boleto.getTipoBloqueto())));
            result.add(dto);
        }
        return result;
    }

    @Generated
    public AlteracaoVencimentoParcelaDTO() {
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public LocalDate getVencimento() {
        return this.vencimento;
    }

    @Generated
    public Boolean getCotaUnica() {
        return this.cotaUnica;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setVencimento(LocalDate vencimento) {
        this.vencimento = vencimento;
    }

    @Generated
    public void setCotaUnica(Boolean cotaUnica) {
        this.cotaUnica = cotaUnica;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlteracaoVencimentoParcelaDTO)) {
            return false;
        }
        AlteracaoVencimentoParcelaDTO other = (AlteracaoVencimentoParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Boolean this$cotaUnica = this.getCotaUnica();
        Boolean other$cotaUnica = other.getCotaUnica();
        if (this$cotaUnica == null ? other$cotaUnica != null : !((Object)this$cotaUnica).equals(other$cotaUnica)) {
            return false;
        }
        LocalDate this$vencimento = this.getVencimento();
        LocalDate other$vencimento = other.getVencimento();
        return !(this$vencimento == null ? other$vencimento != null : !((Object)this$vencimento).equals(other$vencimento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlteracaoVencimentoParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Boolean $cotaUnica = this.getCotaUnica();
        result = result * 59 + ($cotaUnica == null ? 43 : ((Object)$cotaUnica).hashCode());
        LocalDate $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : ((Object)$vencimento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlteracaoVencimentoParcelaDTO(parcela=" + this.getParcela() + ", vencimento=" + String.valueOf(this.getVencimento()) + ", cotaUnica=" + this.getCotaUnica() + ")";
    }
}

