/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.domain.SituacaoLoteGeracaoArquivo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="calculoloteimpressao")
public class CalculoLoteImpressao
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_calculoloteimpressao")
    private Long id;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne
    @JoinColumn(name="idgeracaolote")
    private CalculoGeracaoLote calculoGeracaoLote;
    @Length(max=400)
    private @Length(max=400) String descricao;
    private Long ordem;
    @Formula(value="( select count(*) from calculoloteimpressaoitem clii where clii.idcalculoloteimpressao = id ) ")
    private Long quantidadeItens;
    private UUID idArquivoGrafica;
    private LocalDate dataGeracaoArquivo;
    private UUID idCarnePdf;
    private LocalDate dataGeracaoCarnePdf;
    @Enumerated(value=EnumType.STRING)
    private SituacaoLoteGeracaoArquivo situacao;

    @Generated
    public CalculoLoteImpressao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoGeracaoLote getCalculoGeracaoLote() {
        return this.calculoGeracaoLote;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public Long getQuantidadeItens() {
        return this.quantidadeItens;
    }

    @Generated
    public UUID getIdArquivoGrafica() {
        return this.idArquivoGrafica;
    }

    @Generated
    public LocalDate getDataGeracaoArquivo() {
        return this.dataGeracaoArquivo;
    }

    @Generated
    public UUID getIdCarnePdf() {
        return this.idCarnePdf;
    }

    @Generated
    public LocalDate getDataGeracaoCarnePdf() {
        return this.dataGeracaoCarnePdf;
    }

    @Generated
    public SituacaoLoteGeracaoArquivo getSituacao() {
        return this.situacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCalculoGeracaoLote(CalculoGeracaoLote calculoGeracaoLote) {
        this.calculoGeracaoLote = calculoGeracaoLote;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setQuantidadeItens(Long quantidadeItens) {
        this.quantidadeItens = quantidadeItens;
    }

    @Generated
    public void setIdArquivoGrafica(UUID idArquivoGrafica) {
        this.idArquivoGrafica = idArquivoGrafica;
    }

    @Generated
    public void setDataGeracaoArquivo(LocalDate dataGeracaoArquivo) {
        this.dataGeracaoArquivo = dataGeracaoArquivo;
    }

    @Generated
    public void setIdCarnePdf(UUID idCarnePdf) {
        this.idCarnePdf = idCarnePdf;
    }

    @Generated
    public void setDataGeracaoCarnePdf(LocalDate dataGeracaoCarnePdf) {
        this.dataGeracaoCarnePdf = dataGeracaoCarnePdf;
    }

    @Generated
    public void setSituacao(SituacaoLoteGeracaoArquivo situacao) {
        this.situacao = situacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoLoteImpressao)) {
            return false;
        }
        CalculoLoteImpressao other = (CalculoLoteImpressao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoLoteImpressao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoLoteImpressao(id=" + this.getId() + ")";
    }
}

