/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.CalculoResultado;
import br.com.elotech.tributos.calculo.domain.CalculoTrace;
import br.com.elotech.tributos.calculo.dto.VariavelDTO;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;

@Table(name="calculolinha")
@Entity
public class CalculoLinha
implements EloEntity<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_calculolinha")
    @SequenceGenerator(name="seq_calculolinha", sequenceName="seq_calculolinha")
    private Long id;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="calculoresultado", referencedColumnName="id")
    private CalculoResultado calculoResultado;
    private String identificador;
    private BigDecimal valor;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idcampodinamico", referencedColumnName="id")
    private Campo campoDinamico;
    private Long idSegmento;
    @OneToMany(mappedBy="calculoLinha", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoTrace> trace = new ArrayList();

    public static CalculoLinha from(Long idSegmento, CalculoResultado calculoResultado, String identificador, Double valor, Campo campoDinamico, List<VariavelDTO> variavelDTOS) {
        CalculoLinha calculoLinha = new CalculoLinha();
        calculoLinha.setCalculoResultado(calculoResultado);
        calculoLinha.setIdentificador(identificador);
        calculoLinha.setIdSegmento(idSegmento);
        calculoLinha.setCampoDinamico(campoDinamico);
        Optional.ofNullable(valor).map(BigDecimal::valueOf).ifPresent(arg_0 -> calculoLinha.setValor(arg_0));
        Optional.ofNullable(variavelDTOS).map(dtos -> dtos.stream().map(dto -> CalculoTrace.from((CalculoLinha)calculoLinha, (VariavelDTO)dto)).collect(Collectors.toList())).ifPresent(arg_0 -> calculoLinha.setTrace(arg_0));
        return calculoLinha;
    }

    @Generated
    public CalculoLinha() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoResultado getCalculoResultado() {
        return this.calculoResultado;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Campo getCampoDinamico() {
        return this.campoDinamico;
    }

    @Generated
    public Long getIdSegmento() {
        return this.idSegmento;
    }

    @Generated
    public List<CalculoTrace> getTrace() {
        return this.trace;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCalculoResultado(CalculoResultado calculoResultado) {
        this.calculoResultado = calculoResultado;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setCampoDinamico(Campo campoDinamico) {
        this.campoDinamico = campoDinamico;
    }

    @Generated
    public void setIdSegmento(Long idSegmento) {
        this.idSegmento = idSegmento;
    }

    @Generated
    public void setTrace(List<CalculoTrace> trace) {
        this.trace = trace;
    }

    @Generated
    public String toString() {
        return "CalculoLinha(id=" + this.getId() + ", calculoResultado=" + String.valueOf(this.getCalculoResultado()) + ", identificador=" + this.getIdentificador() + ", valor=" + String.valueOf(this.getValor()) + ", campoDinamico=" + String.valueOf(this.getCampoDinamico()) + ", idSegmento=" + this.getIdSegmento() + ", trace=" + String.valueOf(this.getTrace()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoLinha)) {
            return false;
        }
        CalculoLinha other = (CalculoLinha)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoLinha;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

