/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfig;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigCampo;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigCampoDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.TipoDivida;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ArquivoGraficaConfigDTO {
    private Long id;
    @NotNull
    private TipoDivida tipoDivida;
    private List<ArquivoGraficaConfigCampoDTO> campos = new ArrayList();
    private Long quantidadeCampos;

    public ArquivoGraficaConfig toEntity() {
        ArquivoGraficaConfig entity = new ArquivoGraficaConfig();
        entity.setId(this.getId());
        entity.setTipoDivida(this.getTipoDivida());
        entity.getCampos().addAll(this.getCampos().stream().map(ArquivoGraficaConfigCampoDTO::toEntity).collect(Collectors.toList()));
        return entity;
    }

    public static ArquivoGraficaConfigDTO from(ArquivoGraficaConfig entity, List<CampoDetalheDTO> campoDetalheDisponiveis) {
        ArquivoGraficaConfigDTO dto = new ArquivoGraficaConfigDTO();
        dto.setId(entity.getId());
        dto.setTipoDivida(entity.getTipoDivida());
        dto.getCampos().addAll(entity.getCampos().stream().map(campo -> {
            if (Objects.nonNull(campo.getIdCampoDinamico())) {
                CampoDetalheDTO campoCorrespondente = campoDetalheDisponiveis.stream().filter(campoDisponivel -> Objects.nonNull(campoDisponivel.getIdCampoDinamico()) && campoDisponivel.getIdCampoDinamico().equals(campo.getIdCampoDinamico())).findFirst().orElseGet(() -> null);
                return ArquivoGraficaConfigCampoDTO.from((ArquivoGraficaConfigCampo)campo, (CampoDetalheDTO)campoCorrespondente);
            }
            CampoDetalheDTO campoCorrespondente = campoDetalheDisponiveis.stream().filter(campoDisponivel -> campoDisponivel.getNome().equals(campo.getCampo()) && campoDisponivel.getTabela().equals(campo.getTabela())).findFirst().orElseGet(() -> null);
            return ArquivoGraficaConfigCampoDTO.from((ArquivoGraficaConfigCampo)campo, (CampoDetalheDTO)campoCorrespondente);
        }).collect(Collectors.toList()));
        dto.setQuantidadeCampos(entity.getQuantidadeCampos());
        return dto;
    }

    @Generated
    public ArquivoGraficaConfigDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoDivida getTipoDivida() {
        return this.tipoDivida;
    }

    @Generated
    public List<ArquivoGraficaConfigCampoDTO> getCampos() {
        return this.campos;
    }

    @Generated
    public Long getQuantidadeCampos() {
        return this.quantidadeCampos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoDivida(TipoDivida tipoDivida) {
        this.tipoDivida = tipoDivida;
    }

    @Generated
    public void setCampos(List<ArquivoGraficaConfigCampoDTO> campos) {
        this.campos = campos;
    }

    @Generated
    public void setQuantidadeCampos(Long quantidadeCampos) {
        this.quantidadeCampos = quantidadeCampos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArquivoGraficaConfigDTO)) {
            return false;
        }
        ArquivoGraficaConfigDTO other = (ArquivoGraficaConfigDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$quantidadeCampos = this.getQuantidadeCampos();
        Long other$quantidadeCampos = other.getQuantidadeCampos();
        if (this$quantidadeCampos == null ? other$quantidadeCampos != null : !((Object)this$quantidadeCampos).equals(other$quantidadeCampos)) {
            return false;
        }
        TipoDivida this$tipoDivida = this.getTipoDivida();
        TipoDivida other$tipoDivida = other.getTipoDivida();
        if (this$tipoDivida == null ? other$tipoDivida != null : !this$tipoDivida.equals(other$tipoDivida)) {
            return false;
        }
        List this$campos = this.getCampos();
        List other$campos = other.getCampos();
        return !(this$campos == null ? other$campos != null : !((Object)this$campos).equals(other$campos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArquivoGraficaConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $quantidadeCampos = this.getQuantidadeCampos();
        result = result * 59 + ($quantidadeCampos == null ? 43 : ((Object)$quantidadeCampos).hashCode());
        TipoDivida $tipoDivida = this.getTipoDivida();
        result = result * 59 + ($tipoDivida == null ? 43 : $tipoDivida.hashCode());
        List $campos = this.getCampos();
        result = result * 59 + ($campos == null ? 43 : ((Object)$campos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArquivoGraficaConfigDTO(id=" + this.getId() + ", tipoDivida=" + String.valueOf(this.getTipoDivida()) + ", campos=" + String.valueOf(this.getCampos()) + ", quantidadeCampos=" + this.getQuantidadeCampos() + ")";
    }
}

