/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigCampo;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.util.Assert;

@Entity
@Table(name="arquivograficaconfig")
public class ArquivoGraficaConfig
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_arquivograficaconfig", applyOnMerge=true)
    private Long id;
    @NotNull
    private TipoDivida tipoDivida;
    @OneToMany(mappedBy="arquivoGraficaConfig", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<ArquivoGraficaConfigCampo> campos = new ArrayList();

    public Long getQuantidadeCampos() {
        return this.campos.size();
    }

    public ArquivoGraficaConfig merge(ArquivoGraficaConfig entityToMerge) {
        Assert.isTrue((boolean)entityToMerge.getId().equals(this.getId()), (String)"Para fazer o merge, a configura\u00e7\u00e3o deve ter o mesmo id");
        this.setTipoDivida(entityToMerge.getTipoDivida());
        this.mergeCampos(entityToMerge.getCampos());
        return this;
    }

    private void mergeCampos(List<ArquivoGraficaConfigCampo> campos) {
        List merged = ListUtils.merge((List)this.getCampos(), campos, ArquivoGraficaConfigCampo::getId, ArquivoGraficaConfigCampo::merge);
        this.getCampos().clear();
        this.getCampos().addAll(merged);
    }

    @Generated
    public ArquivoGraficaConfig() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoDivida getTipoDivida() {
        return this.tipoDivida;
    }

    @Generated
    public List<ArquivoGraficaConfigCampo> getCampos() {
        return this.campos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoDivida(TipoDivida tipoDivida) {
        this.tipoDivida = tipoDivida;
    }

    @Generated
    public void setCampos(List<ArquivoGraficaConfigCampo> campos) {
        this.campos = campos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArquivoGraficaConfig)) {
            return false;
        }
        ArquivoGraficaConfig other = (ArquivoGraficaConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArquivoGraficaConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArquivoGraficaConfig(id=" + this.getId() + ")";
    }
}

