/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.pgfn.processamento;

import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemEntityDTO;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnDadosDebitoRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ProcessamentoArquivoPgfnBatchWriter
implements ItemWriter<PgfnArquivoItemEntityDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoArquivoPgfnBatchWriter.class);
    private final PgfnDadosDebitoRepository pgfnDadosDebitoRepository;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends PgfnArquivoItemEntityDTO> items) throws Exception {
        for (PgfnArquivoItemEntityDTO pgfnArquivoItemEntityDTO : items) {
            if (pgfnArquivoItemEntityDTO.getDadosDebito() == null) continue;
            this.pgfnDadosDebitoRepository.save((Object)pgfnArquivoItemEntityDTO.getDadosDebito());
        }
    }

    @AfterWrite
    public void afterWrite(List<? extends PgfnArquivoItemEntityDTO> items) {
        Long idArquivoPgfn = this.stepExecution.getJobExecution().getJobParameters().getLong("idArquivoPgfn");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk do arquivo PGFN {}. Itens processados at\u00e9 o momento {}", (Object)idArquivoPgfn, (Object)quantidadeProcessada);
    }

    @Generated
    public ProcessamentoArquivoPgfnBatchWriter(PgfnDadosDebitoRepository pgfnDadosDebitoRepository) {
        this.pgfnDadosDebitoRepository = pgfnDadosDebitoRepository;
    }
}

