/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import br.com.elotech.tributos.batch.simulacaocalculo.SimulacaoCalculoBatchReader;
import br.com.elotech.tributos.domain.TipoDivida;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoCalculoBatchReader
extends JdbcPagingItemReader<Long> {
    public SimulacaoCalculoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(50);
        this.setName("idCadastroGeral");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("idkey"));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        String filtroCadastro = (String)jobParameters.get("filtroCadastro");
        String filtroSemEnglobados = "";
        TipoDivida tipoDivida = TipoDivida.fromValue((String)((String)jobParameters.get("tipoDivida")));
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoDivida[tipoDivida.ordinal()]) {
            case 1: {
                filtroSemEnglobados = " and coalesce(cadastrogeral.englobado, 'N') = 'N'  and not exists (select cie.cadastrogeral_englobado_idkey                    from tribimobiliarioenglobado cie                   where cie.cadastrogeral_englobado_idkey = cadastrogeral.idkey) ";
                break;
            }
        }
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        provider.setDataSource(dataSource);
        provider.setSelectClause("select idkey");
        provider.setFromClause("from tribcadastrogeral cadastrogeral");
        provider.setWhereClause(String.format("where exclusaologica = 'N' and %s %s", filtroCadastro, filtroSemEnglobados));
        provider.setSortKey("idkey");
        return provider;
    }
}

