/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoCalculoBatchProcessor
implements ItemProcessor<Long, List<CalculoCadastro>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoCalculoBatchProcessor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulacaoCalculoBatchProcessor.class);
    private StepExecution stepExecution;
    private CalculoTabelaValores calculoTabelaValores;
    private final CalculoService calculoService;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public List<CalculoCadastro> process(Long idCadastroGeral) {
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}.", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Realizando a simula\u00e7\u00e3o de c\u00e1lculo do cadastro geral com ID: {}", (Object)idCadastroGeral);
        List tributos = (List)this.stepExecution.getJobExecution().getExecutionContext().get("tributos");
        String parametroIsencaoValorMinimo = (String)this.stepExecution.getJobExecution().getExecutionContext().get("parametroIsencaoValorMinimo");
        BigDecimal parametroIsencaoValorMaximoReducao = (BigDecimal)this.stepExecution.getJobExecution().getExecutionContext().get("parametroIsencaoValorMaximoReducao");
        Long idCalculo = this.stepExecution.getJobParameters().getLong("idCalculo");
        Calculo calculo = (Calculo)this.calculoService.findOne((Serializable)idCalculo);
        this.loadCalculoTabelaValores(calculo.getExercicio());
        return this.calculoService.calcularByCadastroSemCompilarFormulas(calculo, tributos, idCadastroGeral, parametroIsencaoValorMinimo, parametroIsencaoValorMaximoReducao, this.calculoTabelaValores);
    }

    private void loadCalculoTabelaValores(Long exercicio) {
        if (Objects.nonNull(this.calculoTabelaValores)) {
            return;
        }
        this.calculoTabelaValores = this.calculoService.loadCalculoTabelaValores(exercicio);
    }

    @Generated
    public SimulacaoCalculoBatchProcessor(CalculoService calculoService) {
        this.calculoService = calculoService;
    }
}

