/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.validaregrasimportacao;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ValidaRegrasImportacaoSimAMJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidaRegrasImportacaoSimAMJobListener.class);
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Optional notificacaoId = this.notificacaoService.send("SIM-AM - Valida\u00e7\u00e3o de Regras de Importa\u00e7\u00e3o iniciada", "Foi iniciada a valida\u00e7\u00e3o das regras de importa\u00e7\u00e3o do SIM-AM", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put("idNotificacao", notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString("idNotificacao"));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Valida\u00e7\u00e3o de Regras de Importa\u00e7\u00e3o finalizada com sucesso", "A valida\u00e7\u00e3o das regras de importa\u00e7\u00e3o do SIM-AM foi finalizada com sucesso", jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Valida\u00e7\u00e3o de Regras de Importa\u00e7\u00e3o finalizada com falha", "A valida\u00e7\u00e3o das regras de importa\u00e7\u00e3o do SIM-AM foi finalizada com falha", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ValidaRegrasImportacaoSimAMJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

