/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.movimentacaomensal;

import br.com.elotech.tributos.batch.simam.movimentacaomensal.MovimentacaoMensalJobListener;
import br.com.elotech.tributos.domain.JobType;
import java.time.Month;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.DefaultJobParametersValidator;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MovimentacaoMensalBatchConfig {
    @Qualifier(value="lancamentoCreditoStep")
    @Autowired
    private Step lancamentoCreditoStep;
    @Qualifier(value="deducaoCreditoStep")
    @Autowired
    private Step deducaoCreditoStep;
    @Qualifier(value="atualizacaoCreditoStep")
    @Autowired
    private Step atualizacaoCreditoStep;
    @Qualifier(value="inscricaoDividaAtivaStep")
    @Autowired
    private Step inscricaoDividaAtivaStep;
    @Qualifier(value="deducaoCreditoDividaAtivaStep")
    @Autowired
    private Step deducaoCreditoDividaAtivaStep;
    @Qualifier(value="atualizacaoMonetariaCreditoDAStep")
    @Autowired
    private Step atualizacaoMonetariaCreditoDAStep;
    @Qualifier(value="arrecadacaoCreditoStep")
    @Autowired
    private Step arrecadacaoCreditoStep;
    @Qualifier(value="estornoLancamentoCreditoStep")
    @Autowired
    private Step estornoLancamentoCreditoStep;
    @Qualifier(value="estornoDeducaoCreditoStep")
    @Autowired
    private Step estornoDeducaoCreditoStep;
    @Qualifier(value="estornoAtualizacaoCreditoStep")
    @Autowired
    private Step estornoAtualizacaoCreditoStep;
    @Qualifier(value="estornoInscricaoDividaAtivaStep")
    @Autowired
    private Step estornoInscricaoDividaAtivaStep;
    @Qualifier(value="estornoDeducaoCreditoDividaAtivaStep")
    @Autowired
    private Step estornoDeducaoCreditoDividaAtivaStep;
    @Qualifier(value="estornoAtualizacaoMonetariaCreditoDAStep")
    @Autowired
    private Step estornoAtualizacaoMonetariaCreditoDAStep;
    @Qualifier(value="estornoArrecadacaoCreditoStep")
    @Autowired
    private Step estornoArrecadacaoCreditoStep;
    @Qualifier(value="lancamentoCreditoImplantacaoSaldoStep")
    @Autowired
    private Step lancamentoCreditoImplantacaoSaldoStep;
    @Qualifier(value="inscricaoDividaAtivaImplantacaoSaldoStep")
    @Autowired
    private Step inscricaoDividaAtivaImplantacaoSaldoStep;

    @Bean
    public Job movimentacaoMensalBatchJob(JobBuilderFactory jobBuilderFactory, MovimentacaoMensalJobListener listener) {
        DefaultJobParametersValidator validator = new DefaultJobParametersValidator();
        validator.setRequiredKeys(new String[]{"entidade", "dataInicial", "dataFinal"});
        Flow flowImplantacaoSaldo = (Flow)new FlowBuilder("implantacaoSaldo").start(this.lancamentoCreditoImplantacaoSaldoStep).next(this.inscricaoDividaAtivaImplantacaoSaldoStep).build();
        Flow flowMovimentacaoMensal = (Flow)new FlowBuilder("movimentacaoMensal").start(this.lancamentoCreditoStep).next(this.deducaoCreditoStep).next(this.atualizacaoCreditoStep).next(this.inscricaoDividaAtivaStep).next(this.deducaoCreditoDividaAtivaStep).next(this.atualizacaoMonetariaCreditoDAStep).next(this.arrecadacaoCreditoStep).next(this.estornoLancamentoCreditoStep).next(this.estornoDeducaoCreditoStep).next(this.estornoAtualizacaoCreditoStep).next(this.estornoInscricaoDividaAtivaStep).next(this.estornoDeducaoCreditoDividaAtivaStep).next(this.estornoAtualizacaoMonetariaCreditoDAStep).next(this.estornoArrecadacaoCreditoStep).build();
        JobExecutionDecider decider = (jobExecution, stepExecution) -> {
            Date data = jobExecution.getJobParameters().getDate("dataInicial");
            Month mes = data.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getMonth();
            return Month.JANUARY.equals(mes) ? new FlowExecutionStatus("IMPLANTACAO") : new FlowExecutionStatus("MENSAL");
        };
        return ((FlowJobBuilder)new SimpleJobBuilder(((JobBuilder)((JobBuilder)jobBuilderFactory.get(JobType.SIMAM_MOVIMENTACAO_MENSAL.getTipo()).validator((JobParametersValidator)validator)).listener((JobExecutionListener)listener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(decider).on("IMPLANTACAO").to(flowImplantacaoSaldo).next(flowMovimentacaoMensal).from(decider).on("MENSAL").to(flowMovimentacaoMensal).end()).build();
    }
}

