/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class LancamentoCreditoJobListener
extends JobExecutionListenerSupport {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Optional notificacaoId = this.notificacaoService.send(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Lan\u00e7amento de Cr\u00e9dito - %s -> %s", dataInicial.toString(), dataFinal.toString()), "SIM-AM - Lan\u00e7amento de Cr\u00e9dito iniciado", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Optional notificacaoId = this.notificacaoService.getNotificacaoIdFromJobContext(jobExecution.getExecutionContext().get(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Os dados referentes ao Lan\u00e7amento de Cr\u00e9dito no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial.toString(), dataFinal.toString()), "SIM-AM - Lan\u00e7amento de Cr\u00e9dito finalizado com sucesso", jobExecution, notificacaoId, NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("N\u00e3o foi poss\u00edvel gerar os dados.", "Erro na gera\u00e7\u00e3o de dados do SIM-AM - Lan\u00e7amento de Cr\u00e9dito", jobExecution, notificacaoId, NotificationStatus.FAILED);
        }
    }

    @Generated
    public LancamentoCreditoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

