/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.tributos.batch.simam.ReferenciaOrigemParcelamentoService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.RestituicaoDebitoDividaAtiva;
import br.com.elotech.tributos.domain.simam.RestituicaoDebitoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.TipoLancamentoCredito;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.InscricaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class InscricaoDividaAtivaBatchProcessor
implements ItemProcessor<InscricaoCreditoDividaAtivaConsultaDTO, TipoLancamentoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InscricaoDividaAtivaBatchProcessor.class);
    private Map<Long, FormaCorrecao> formasDeCorrecao = new ConcurrentHashMap();
    private Map<Long, FormaCorrecao> outrasFormasDeCorrecao = new ConcurrentHashMap();
    private List<MudancaMonetaria> mudancasMonetarias = new ArrayList();
    private final EntityManager entityManager;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private LocalDate dataReferencia = null;
    private Boolean isImplantacaoSaldo = Boolean.FALSE;
    private final FormaCorrecaoService formaCorrecaoService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final ReferenciaOrigemParcelamentoService referenciaOrigemParcelamentoService;
    private Map<String, Long> cargaExistente = new HashMap();
    private AtomicLong ultimoNrDivida = new AtomicLong(0L);
    private Long nrAnoDivida;
    private LocalDate dataInicial;
    private LocalDate dataFinal;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados");
        this.dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataReferencia")));
        this.isImplantacaoSaldo = "true".equals(stepExecution.getExecutionContext().getString("implantacaoSaldo", "false"));
        this.outrasFormasDeCorrecao = new ConcurrentHashMap();
        this.formasDeCorrecao = new ConcurrentHashMap();
        this.ultimoNrDivida.set(this.inscricaoCreditoDividaAtivaRepository.findNextNrDividaByExercicio(this.nrAnoDivida));
        if (this.isImplantacaoSaldo.booleanValue()) {
            this.nrAnoDivida = stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
            Long exercicio = stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
            Long idControle = stepExecution.getJobExecution().getJobParameters().getLong("idControle");
            LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Implanta\u00e7\u00e3o Saldo - Iniciando gera\u00e7\u00e3o de dados - idControle: {}, exercicio: {} ", (Object)idControle, (Object)exercicio);
            return;
        }
        this.dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        this.dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        this.nrAnoDivida = this.dataInicial.getYear();
        this.ultimoNrDivida.set(this.inscricaoCreditoDividaAtivaRepository.findNextNrDividaByExercicio(this.nrAnoDivida));
        LOGGER.info("Carregando a carga existente");
        this.inscricaoCreditoDividaAtivaRepository.getCargaExistente(this.dataInicial, this.dataFinal).forEach(itemCargaExistente -> this.cargaExistente.put(itemCargaExistente.buildChaveAgrupamento(), itemCargaExistente.getIdInscricao()));
        LOGGER.info("Finalizou a carga dos itens existentes.");
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {} ", (Object)this.dataInicial, (Object)this.dataFinal);
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - carregando lista das formas de corre\u00e7\u00f5es existentes");
        this.formaCorrecaoService.findAll(Pageable.unpaged()).getContent().stream().map(FormaCorrecao::getId).forEach(idFormaCorrecao -> this.formasDeCorrecao.put(idFormaCorrecao, this.formaCorrecaoService.findOne(idFormaCorrecao)));
        this.mudancasMonetarias = this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public TipoLancamentoCredito process(InscricaoCreditoDividaAtivaConsultaDTO item) {
        FormaCorrecao formaCorrecao = this.resolveFormaCorrecao(item);
        if (this.isImplantacaoSaldo.booleanValue()) {
            item.setValorCorrigido(item.getVlInscricao());
        } else {
            BigDecimal valorCorrigido = CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getVlInscricao(), (LocalDate)item.getDtInscricao(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias);
            item.setValorCorrigido(valorCorrigido);
        }
        Long inscricaoCreditoDividaAtiva = this.getOrCreateInscricaoDividaAtiva(this.cargaExistente, item);
        if (TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()).equals((Object)TipoOperacaoCredito.DIVIDAS_A_RESTITUIR)) {
            RestituicaoDebitoDividaAtivaId id = new RestituicaoDebitoDividaAtivaId();
            id.setInscricaoCreditoDividaAtiva((InscricaoCreditoDividaAtiva)this.entityManager.getReference(InscricaoCreditoDividaAtiva.class, (Object)inscricaoCreditoDividaAtiva));
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaTributoDestino()));
            id.setDevolucaoCredito((DevolucaoCredito)this.entityManager.getReference(DevolucaoCredito.class, (Object)item.getIdDevolucaoCredito()));
            id.setSequenciaItem(Long.valueOf(item.getSequenciaItem() != null ? item.getSequenciaItem() : 0L));
            id.setSequenciaDebito(Long.valueOf(item.getSequenciaDebito() != null ? item.getSequenciaDebito() : 0L));
            RestituicaoDebitoDividaAtiva restituicaoLancamentoCredito = new RestituicaoDebitoDividaAtiva();
            restituicaoLancamentoCredito.setId(id);
            restituicaoLancamentoCredito.setAnoGerado(Long.valueOf(item.getDtInscricao().getYear()));
            restituicaoLancamentoCredito.setMesGerado(Long.valueOf(item.getDtInscricao().getMonth().getValue()));
            restituicaoLancamentoCredito.setValor(CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getVlInscricao(), (LocalDate)item.getDtInscricao(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias));
            return restituicaoLancamentoCredito;
        }
        DebitoInscricaoDividaAtiva debitoInscricaoDividaAtiva = new DebitoInscricaoDividaAtiva();
        debitoInscricaoDividaAtiva.setId(new DebitoInscricaoDividaAtivaId());
        debitoInscricaoDividaAtiva.getId().setIdtceinsccreditoda(inscricaoCreditoDividaAtiva);
        debitoInscricaoDividaAtiva.getId().setIdDebitoParcelaTributo(item.getIdDebitoParcelaTributoDestino());
        debitoInscricaoDividaAtiva.setValor(item.getValorCorrigido());
        debitoInscricaoDividaAtiva.setAnoGerado(this.nrAnoDivida);
        debitoInscricaoDividaAtiva.setMesGerado(Long.valueOf(this.isImplantacaoSaldo != false ? 1L : (long)this.dataInicial.getMonthValue()));
        return debitoInscricaoDividaAtiva;
    }

    private Long getOrCreateInscricaoDividaAtiva(Map<String, Long> cargaExistente, InscricaoCreditoDividaAtivaConsultaDTO item) {
        return cargaExistente.compute(item.buildChaveAgrupamento(), (chave, inscricaoJaExistente) -> {
            if (Objects.nonNull(inscricaoJaExistente)) {
                return inscricaoJaExistente;
            }
            InscricaoCreditoDividaAtiva newValue = new InscricaoCreditoDividaAtiva();
            newValue.setTipoNaturezaCredito(TipoNaturezaCredito.fromValue((Long)item.getIdTipoNaturezaCredito()));
            if (Objects.nonNull(item.getIdTipoCredito())) {
                newValue.setTipoCredito(ClassificacaoTipoTributo.fromValue((Integer)item.getIdTipoCredito().intValue()));
            }
            newValue.setTipoOperacaoCredito(TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()));
            newValue.setDataInscricao(item.getDtInscricao());
            Long anoInscricao = Optional.ofNullable(item.getDtInscricao()).map(LocalDate::getYear).map(Long::valueOf).orElse(null);
            newValue.setNrAnoDivida(this.nrAnoDivida);
            newValue.setNrDivida(Long.valueOf(this.ultimoNrDivida.getAndIncrement()));
            newValue.setNrCredito(item.getNrCredito());
            newValue.setNrAnoCredito(item.getNrAnoCredito());
            newValue.setNrAnoBase(item.getNrAnoBase());
            newValue.setCdControleLeiAto(item.getCdControleLeiAto());
            newValue.setNrAnoInscricao(anoInscricao);
            this.inscricaoCreditoDividaAtivaRepository.save((Object)newValue);
            LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - gerando novo registro -> ({}/{})", (Object)newValue.getNrDivida(), (Object)newValue.getNrAnoDivida());
            return newValue.getId();
        });
    }

    private FormaCorrecao resolveFormaCorrecao(InscricaoCreditoDividaAtivaConsultaDTO item) {
        if (Objects.nonNull(item.getFormaCorrecao())) {
            return (FormaCorrecao)this.formasDeCorrecao.get(item.getFormaCorrecao());
        }
        return Optional.ofNullable((FormaCorrecao)this.outrasFormasDeCorrecao.get(item.getIdDivida())).orElseGet(() -> {
            FormaCorrecao formaCorrecaoPadrao = this.formaCorrecaoService.getFormaCorrecaoPadrao(item.getIdDivida(), item.getEntidade(), item.getExercicio());
            this.outrasFormasDeCorrecao.put(item.getIdDivida(), formaCorrecaoPadrao);
            return formaCorrecaoPadrao;
        });
    }

    @OnProcessError
    public void onProcessError(InscricaoCreditoDividaAtivaConsultaDTO item, Exception e) throws JsonProcessingException {
        LOGGER.error("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - erro: {})", (Object)e.getMessage());
    }

    @AfterStep
    public ExitStatus onAfterStep(StepExecution stepExecution) {
        if (Boolean.FALSE.equals(this.isImplantacaoSaldo)) {
            try {
                this.referenciaOrigemParcelamentoService.atualizaReferenciaDividaAtiva(stepExecution.getJobExecution());
            }
            catch (Exception ex) {
                LOGGER.error("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Erro ao atualizar a referencia origem parcelamento", (Throwable)ex);
                return ExitStatus.FAILED.addExitDescription((Throwable)ex);
            }
        }
        return stepExecution.getExitStatus();
    }

    @Generated
    public InscricaoDividaAtivaBatchProcessor(EntityManager entityManager, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository, FormaCorrecaoService formaCorrecaoService, MudancaMonetariaService mudancaMonetariaService, ReferenciaOrigemParcelamentoService referenciaOrigemParcelamentoService) {
        this.entityManager = entityManager;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
        this.formaCorrecaoService = formaCorrecaoService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.referenciaOrigemParcelamentoService = referenciaOrigemParcelamentoService;
    }
}

