/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldo;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoImplantacaoSaldo;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ImplantacaoSaldoJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String DATA_FINAL = "dataFinal";
    private static final String CONTROLE = "idControle";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        ImplantacaoSaldo implantacaoSaldo = (ImplantacaoSaldo)this.implantacaoSaldoRepository.findById((Object)Objects.requireNonNull(jobExecution.getJobParameters().getLong(CONTROLE))).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a implanta\u00e7\u00e3o de saldo."));
        implantacaoSaldo.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.implantacaoSaldoRepository.save((Object)implantacaoSaldo);
        Optional notificacaoId = this.notificacaoService.send("SIM-AM - Implanta\u00e7\u00e3o de Saldo - iniciada", String.format("Foi iniciada a Implanta\u00e7\u00e3o de Saldo para o exercicio %d - data de corte: %s", exercicio, dataFinal), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        ImplantacaoSaldo implantacaoSaldo = (ImplantacaoSaldo)this.implantacaoSaldoRepository.findById((Object)Objects.requireNonNull(jobExecution.getJobParameters().getLong(CONTROLE))).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a implanta\u00e7\u00e3o de saldo."));
        implantacaoSaldo.setSituacao(SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO);
        this.implantacaoSaldoRepository.save((Object)implantacaoSaldo);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Implanta\u00e7\u00e3o de Saldo - finalizado com sucesso", String.format("Os dados referentes a implanta\u00e7\u00e3o de saldo do exercicio %d foram gerados com sucesso.", exercicio), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Implanta\u00e7\u00e3o de Saldo", "N\u00e3o foi poss\u00edvel gerar os dados.", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ImplantacaoSaldoJobListener(NotificacaoService notificacaoService, ImplantacaoSaldoRepository implantacaoSaldoRepository) {
        this.notificacaoService = notificacaoService;
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
    }
}

