/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImplantacaoSaldoBatchReader
extends JdbcCursorItemReader<ImplantacaoSaldoConsultaDTO> {
    public ImplantacaoSaldoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        String entidade = String.valueOf(jobParameters.get("entidade"));
        String exercicio = String.valueOf(jobParameters.get("exercicio"));
        LocalDate dataReferencia = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(10000);
        this.setName("implantacaoSaldoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoConsultaDTO.class));
        String sql = FileUtils.readResourceAsString((String)"sql/simam/GeracaoImplantacaoSaldo.sql").replace(":entidade", entidade).replace(":dataReferencia", StringUtils.wrap((String)dataReferencia.toString(), (String)"'")).replace(":exercicio", exercicio);
        this.setSql(sql);
    }
}

