/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoItem;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoConsultaDTO;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImplantacaoSaldoBatchProcessor
implements ItemProcessor<ImplantacaoSaldoConsultaDTO, ImplantacaoSaldoItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplantacaoSaldoBatchProcessor.class);
    private final Map<Long, FormaCorrecao> formasDeCorrecao = new ConcurrentHashMap();
    private final Map<Long, FormaCorrecao> outrasFormasDeCorrecao = new ConcurrentHashMap();
    private LocalDate dataReferencia = null;
    private Long idControle = null;
    private StepExecution stepExecution;
    private List<MudancaMonetaria> mudancasMonetarias = new ArrayList();
    private final FormaCorrecaoService formaCorrecaoService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final ObjectMapper objectMapper;

    public ImplantacaoSaldoBatchProcessor(FormaCorrecaoService formaCorrecaoService, MudancaMonetariaService mudancaMonetariaService, ObjectMapper objectMapper) {
        this.formaCorrecaoService = formaCorrecaoService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("Iniciando gera\u00e7\u00e3o de dados");
        this.idControle = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("idControle"));
        this.dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataReferencia")));
        LOGGER.debug("Criando lista das formas de corre\u00e7\u00f5es existentes");
        List<Long> correcoes = this.formaCorrecaoService.findAll(Pageable.unpaged()).getContent().stream().map(FormaCorrecao::getId).collect(Collectors.toList());
        LOGGER.info("foram encontrdas {} formas de correcao", (Object)correcoes.size());
        correcoes.forEach(idFormaCorrecao -> {
            LOGGER.debug("Carregando forma de correcao {}", idFormaCorrecao);
            this.formasDeCorrecao.put(idFormaCorrecao, this.formaCorrecaoService.findOne(idFormaCorrecao));
            LOGGER.debug("Carregou forma de correcao {}", idFormaCorrecao);
        });
        LOGGER.info("Criando lista das mudancas monetarias existentes");
        this.mudancasMonetarias = this.mudancaMonetariaService.findByRsql(Optional.empty());
        LOGGER.info("Finalizado before step");
    }

    public ImplantacaoSaldoItem process(ImplantacaoSaldoConsultaDTO item) {
        ImplantacaoSaldoItem implantacaoSaldoItem = new ImplantacaoSaldoItem();
        implantacaoSaldoItem.setImplantacaoSaldo(this.idControle);
        implantacaoSaldoItem.setDebitoParcelaTributo(item.getIdDebitoParcelaReceita());
        implantacaoSaldoItem.setClassificacaoTipoTributo(ClassificacaoTipoTributo.fromValue((Integer)item.getClassificacaoReceita().intValue()));
        implantacaoSaldoItem.setSituacaoLegal(SituacaoLegal.fromValue((Integer)item.getSituacaoLegal().intValue()));
        implantacaoSaldoItem.setSituacaoDebito(item.getSituacaoDebito());
        implantacaoSaldoItem.setDataLancamento(item.getDataLancamento());
        implantacaoSaldoItem.setDataSituacao(item.getDataSituacao());
        implantacaoSaldoItem.setDataDividaAtiva(item.getDataDividaAtiva());
        implantacaoSaldoItem.setFundamentolegal(item.getFundamentolegal());
        implantacaoSaldoItem.setFormaCorrecao(item.getFormaCorrecao());
        implantacaoSaldoItem.setDivida(item.getIdDivida());
        FormaCorrecao formaCorrecao = null;
        formaCorrecao = Objects.nonNull(item.getFormaCorrecao()) ? (FormaCorrecao)this.formasDeCorrecao.get(item.getFormaCorrecao()) : Optional.ofNullable((FormaCorrecao)this.outrasFormasDeCorrecao.get(item.getIdDivida())).orElseGet(() -> {
            FormaCorrecao fc = this.formaCorrecaoService.getFormaCorrecaoPadrao(item.getIdDivida(), item.getEntidade(), item.getExercicio());
            this.outrasFormasDeCorrecao.put(item.getIdDivida(), fc);
            return fc;
        });
        implantacaoSaldoItem.setValor(CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getValor(), (LocalDate)item.getDataLancamento(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias));
        return implantacaoSaldoItem;
    }

    @OnProcessError
    public void onProcessError(ImplantacaoSaldoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }
}

