/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito.dividaativa;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoDeducaoCreditoDividaAtivaJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoDeducaoCreditoDividaAtivaJobListener.class);
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA = "SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Optional notificacaoId = this.notificacaoService.send(ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA, String.format("Iniciada a gera\u00e7\u00e3o de dados de Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa para a entidade %s - %s -> %s", entidade, dataInicial.toString(), dataFinal.toString()), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Optional notificacaoId = this.notificacaoService.getNotificacaoIdFromJobContext(jobExecution.getExecutionContext().get(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - finalizado com sucesso", String.format("Os dados referentes aos Estornos Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa da entidade %d foram gerados com sucesso.", entidade), jobExecution, notificacaoId, NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ", "N\u00e3o foi poss\u00edvel gerar os dados.", jobExecution, notificacaoId, NotificationStatus.FAILED);
        }
    }

    @Generated
    public EstornoDeducaoCreditoDividaAtivaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

