/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito.dividaativa;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.EstornoDeducaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoDeducaoCreditoDividaAtivaBatchReader
extends JdbcCursorItemReader<EstornoDeducaoCreditoDividaAtivaConsultaDTO> {
    public EstornoDeducaoCreditoDividaAtivaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        String entidade = String.valueOf(jobParameters.get("entidade"));
        String exercicio = String.valueOf(jobParameters.get("exercicio"));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(10000);
        this.setName("simamEstornoDeducaoCreditoDividaAtivaId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(EstornoDeducaoCreditoDividaAtivaConsultaDTO.class));
        String sql = FileUtils.readResourceAsString((String)"sql/simam/estornoDeducaoCreditoDividaAtivaBatch.sql");
        sql = sql.replace(":dataInicial", "'" + dataInicial.toString() + "'");
        sql = sql.replace(":dataFinal", "'" + dataFinal.toString() + "'");
        sql = sql.replace(":entidade", entidade);
        sql = sql.replace(":exercicio", exercicio);
        this.setSql(sql);
    }
}

