/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito;

import br.com.elotech.tributos.batch.simam.deducaocredito.DeducaoCreditoBatchWriter;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamento;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoParcelamento;
import br.com.elotech.tributos.domain.simam.EstornoTipoDeducaoCredito;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoCancelamentoRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoCreditoRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoPagamentoRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoParcelamentoRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class EstornoDeducaoCreditoBatchWriter
implements ItemWriter<EstornoTipoDeducaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeducaoCreditoBatchWriter.class);
    private final EntityManager entityManager;
    private final EstornoDeducaoCreditoCancelamentoRepository estornoDeducaoCreditoCancelamentoRepository;
    private final EstornoDeducaoCreditoPagamentoRepository estornoDeducaoCreditoPagamentoRepository;
    private final EstornoDeducaoCreditoCreditoRepository estornoDeducaoCreditoCreditoRepository;
    private final EstornoDeducaoParcelamentoRepository estornoDeducaoParcelamentoRepository;
    private StepExecution stepExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Estorno Dedu\u00e7\u00e3o Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends EstornoTipoDeducaoCredito> items) {
        List cancelamentos = items.stream().filter(EstornoDeducaoCancelamento.class::isInstance).map(EstornoDeducaoCancelamento.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(EstornoDeducaoPagamento.class::isInstance).map(EstornoDeducaoPagamento.class::cast).collect(Collectors.toList());
        List creditos = items.stream().filter(EstornoDeducaoCreditoCredito.class::isInstance).map(EstornoDeducaoCreditoCredito.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(EstornoDeducaoParcelamento.class::isInstance).map(EstornoDeducaoParcelamento.class::cast).collect(Collectors.toList());
        this.estornoDeducaoCreditoCancelamentoRepository.saveAll(cancelamentos);
        this.estornoDeducaoCreditoPagamentoRepository.saveAll(pagamentos);
        this.estornoDeducaoCreditoCreditoRepository.saveAll(creditos);
        this.estornoDeducaoParcelamentoRepository.saveAll(parcelamentos);
        this.entityManager.flush();
    }

    @Generated
    public EstornoDeducaoCreditoBatchWriter(EntityManager entityManager, EstornoDeducaoCreditoCancelamentoRepository estornoDeducaoCreditoCancelamentoRepository, EstornoDeducaoCreditoPagamentoRepository estornoDeducaoCreditoPagamentoRepository, EstornoDeducaoCreditoCreditoRepository estornoDeducaoCreditoCreditoRepository, EstornoDeducaoParcelamentoRepository estornoDeducaoParcelamentoRepository) {
        this.entityManager = entityManager;
        this.estornoDeducaoCreditoCancelamentoRepository = estornoDeducaoCreditoCancelamentoRepository;
        this.estornoDeducaoCreditoPagamentoRepository = estornoDeducaoCreditoPagamentoRepository;
        this.estornoDeducaoCreditoCreditoRepository = estornoDeducaoCreditoCreditoRepository;
        this.estornoDeducaoParcelamentoRepository = estornoDeducaoParcelamentoRepository;
    }
}

