/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaomonetariada;

import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaApropriacaoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoCreditoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamentoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaReajusteDA;
import br.com.elotech.tributos.domain.simam.EstornoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.EstornoTipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaApropriacaoDARepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoCreditoDARepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoPagamentoDARepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoParcelamentoDARepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaReajusteDARepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class EstornoAtualizacaoMonetariaCreditoDABatchWriter
implements ItemWriter<EstornoTipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoAtualizacaoMonetariaCreditoDABatchWriter.class);
    private static final String PREFIXO = "SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private final EntityManager entityManager;
    private final EstornoAtualizacaoMonetariaCreditoCreditoDARepository estornoAtualizacaoMonetariaCreditoCreditoDARepository;
    private final EstornoAtualizacaoMonetariaCreditoPagamentoDARepository estornoAtualizacaoMonetariaCreditoPagamentoDARepository;
    private final EstornoAtualizacaoMonetariaApropriacaoDARepository estornoAtualizacaoMonetariaApropriacaoDARepository;
    private final EstornoAtualizacaoMonetariaCreditoParcelamentoDARepository estornoAtualizacaoMonetariaCreditoParcelamentoDARepository;
    private final EstornoAtualizacaoMonetariaReajusteDARepository estornoAtualizacaoMonetariaReajusteDARepository;
    private StepExecution stepExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends EstornoLancamentoCredito> items) {
        LOGGER.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends EstornoTipoAtualizacaoMonetariaCreditoDA> items) {
        List creditos = items.stream().filter(EstornoAtualizacaoMonetariaCreditoCreditoDA.class::isInstance).map(EstornoAtualizacaoMonetariaCreditoCreditoDA.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(EstornoAtualizacaoMonetariaPagamentoDA.class::isInstance).map(EstornoAtualizacaoMonetariaPagamentoDA.class::cast).collect(Collectors.toList());
        List apropriacoes = items.stream().filter(EstornoAtualizacaoMonetariaApropriacaoDA.class::isInstance).map(EstornoAtualizacaoMonetariaApropriacaoDA.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(EstornoAtualizacaoMonetariaCreditoParcelamentoDA.class::isInstance).map(EstornoAtualizacaoMonetariaCreditoParcelamentoDA.class::cast).collect(Collectors.toList());
        List reajustes = items.stream().filter(EstornoAtualizacaoMonetariaReajusteDA.class::isInstance).map(EstornoAtualizacaoMonetariaReajusteDA.class::cast).collect(Collectors.toList());
        this.estornoAtualizacaoMonetariaCreditoCreditoDARepository.saveAll(creditos);
        this.estornoAtualizacaoMonetariaCreditoPagamentoDARepository.saveAll(pagamentos);
        this.estornoAtualizacaoMonetariaApropriacaoDARepository.saveAll(apropriacoes);
        this.estornoAtualizacaoMonetariaCreditoParcelamentoDARepository.saveAll(parcelamentos);
        this.estornoAtualizacaoMonetariaReajusteDARepository.saveAll(reajustes);
        this.entityManager.flush();
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoDABatchWriter(EntityManager entityManager, EstornoAtualizacaoMonetariaCreditoCreditoDARepository estornoAtualizacaoMonetariaCreditoCreditoDARepository, EstornoAtualizacaoMonetariaCreditoPagamentoDARepository estornoAtualizacaoMonetariaCreditoPagamentoDARepository, EstornoAtualizacaoMonetariaApropriacaoDARepository estornoAtualizacaoMonetariaApropriacaoDARepository, EstornoAtualizacaoMonetariaCreditoParcelamentoDARepository estornoAtualizacaoMonetariaCreditoParcelamentoDARepository, EstornoAtualizacaoMonetariaReajusteDARepository estornoAtualizacaoMonetariaReajusteDARepository) {
        this.entityManager = entityManager;
        this.estornoAtualizacaoMonetariaCreditoCreditoDARepository = estornoAtualizacaoMonetariaCreditoCreditoDARepository;
        this.estornoAtualizacaoMonetariaCreditoPagamentoDARepository = estornoAtualizacaoMonetariaCreditoPagamentoDARepository;
        this.estornoAtualizacaoMonetariaApropriacaoDARepository = estornoAtualizacaoMonetariaApropriacaoDARepository;
        this.estornoAtualizacaoMonetariaCreditoParcelamentoDARepository = estornoAtualizacaoMonetariaCreditoParcelamentoDARepository;
        this.estornoAtualizacaoMonetariaReajusteDARepository = estornoAtualizacaoMonetariaReajusteDARepository;
    }
}

