/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaocredito;

import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoCreditoParcelamento;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamento;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaReajuste;
import br.com.elotech.tributos.domain.simam.EstornoTipoAtualizacaoCredito;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoCredito;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoCreditoParcelamentoRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoContribuinteRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaPagamentoRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaReajusteRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class EstornoAtualizacaoCreditoBatchWriter
implements ItemWriter<EstornoTipoAtualizacaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoAtualizacaoCreditoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final EstornoAtualizacaoMonetariaPagamentoRepository estornoAtualizacaoMonetariaPagamentoRepository;
    private final EstornoAtualizacaoMonetariaCreditoContribuinteRepository estornoAtualizacaoMonetariaCreditoContribuinteRepository;
    private final EstornoAtualizacaoCreditoParcelamentoRepository estornoAtualizacaoCreditoParcelamentoRepository;
    private final EstornoAtualizacaoMonetariaReajusteRepository estornoAtualizacaoMonetariaReajusteRepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends EstornoTipoAtualizacaoCredito> items) {
        List creditos = items.stream().filter(EstornoAtualizacaoMonetariaCreditoContribuinte.class::isInstance).map(EstornoAtualizacaoMonetariaCreditoContribuinte.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(EstornoAtualizacaoMonetariaPagamento.class::isInstance).map(EstornoAtualizacaoMonetariaPagamento.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(EstornoAtualizacaoCreditoParcelamento.class::isInstance).map(EstornoAtualizacaoCreditoParcelamento.class::cast).collect(Collectors.toList());
        List reajustes = items.stream().filter(EstornoAtualizacaoMonetariaReajuste.class::isInstance).map(EstornoAtualizacaoMonetariaReajuste.class::cast).collect(Collectors.toList());
        this.estornoAtualizacaoMonetariaPagamentoRepository.saveAll(pagamentos);
        this.estornoAtualizacaoMonetariaCreditoContribuinteRepository.saveAll(creditos);
        this.estornoAtualizacaoCreditoParcelamentoRepository.saveAll(parcelamentos);
        this.estornoAtualizacaoMonetariaReajusteRepository.saveAll(reajustes);
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoAtualizacaoCredito> items) {
        log.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o de Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    @Generated
    public EstornoAtualizacaoCreditoBatchWriter(EntityManager entityManager, EstornoAtualizacaoMonetariaPagamentoRepository estornoAtualizacaoMonetariaPagamentoRepository, EstornoAtualizacaoMonetariaCreditoContribuinteRepository estornoAtualizacaoMonetariaCreditoContribuinteRepository, EstornoAtualizacaoCreditoParcelamentoRepository estornoAtualizacaoCreditoParcelamentoRepository, EstornoAtualizacaoMonetariaReajusteRepository estornoAtualizacaoMonetariaReajusteRepository) {
        this.entityManager = entityManager;
        this.estornoAtualizacaoMonetariaPagamentoRepository = estornoAtualizacaoMonetariaPagamentoRepository;
        this.estornoAtualizacaoMonetariaCreditoContribuinteRepository = estornoAtualizacaoMonetariaCreditoContribuinteRepository;
        this.estornoAtualizacaoCreditoParcelamentoRepository = estornoAtualizacaoCreditoParcelamentoRepository;
        this.estornoAtualizacaoMonetariaReajusteRepository = estornoAtualizacaoMonetariaReajusteRepository;
    }
}

