/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaocredito;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoCreditoParcelamento;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoCreditoParcelamentoId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCredito;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoContribuinteId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamento;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamentoId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaReajuste;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaReajusteId;
import br.com.elotech.tributos.domain.simam.EstornoTipoAtualizacaoCredito;
import br.com.elotech.tributos.dto.simam.EstornoAtualizacaoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoAtualizacaoCreditoBatchProcessor
implements ItemProcessor<EstornoAtualizacaoCreditoConsultaDTO, EstornoTipoAtualizacaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoAtualizacaoCreditoBatchProcessor.class);
    private static final String ESTORNO_ATUALIZACAO_CREDITO = "SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - ";
    private final AtomicLong nrEstorno = new AtomicLong(0L);
    private final EstornoAtualizacaoCreditoRepository estornoAtualizacaoCreditoRepository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EntityManager entityManager;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final ObjectMapper objectMapper;
    private Long nrAnoEstorno;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        log.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - load da carga existente");
        this.estornoAtualizacaoCreditoRepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizaMoneCredEst()));
        this.nrAnoEstorno = dataInicial.getYear();
        this.nrEstorno.set(this.estornoAtualizacaoCreditoRepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public EstornoTipoAtualizacaoCredito process(EstornoAtualizacaoCreditoConsultaDTO dto) {
        String chave = String.format("%d-%d-%s-%d-%d-%d", dto.getNrAtualizacao(), dto.getNrAnoAtualizacao(), dto.getDtEstorno().toString(), dto.getIdAto(), dto.getIdTipoAtualizacaoCredito(), dto.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECRED");
            EstornoAtualizacaoMonetariaCredito estornoTipoAtualizacaoCredito = new EstornoAtualizacaoMonetariaCredito();
            estornoTipoAtualizacaoCredito.setId(nextVal);
            estornoTipoAtualizacaoCredito.setNrEstorno(Long.valueOf(this.nrEstorno.getAndIncrement()));
            estornoTipoAtualizacaoCredito.setNrAnoEstorno(this.nrAnoEstorno);
            estornoTipoAtualizacaoCredito.setNrAtualizacao(dto.getNrAtualizacao());
            estornoTipoAtualizacaoCredito.setNrAnoAtualizacao(dto.getNrAnoAtualizacao());
            estornoTipoAtualizacaoCredito.setCdControleLeiAto(dto.getIdAto());
            estornoTipoAtualizacaoCredito.setDtEstorno(dto.getDtEstorno());
            estornoTipoAtualizacaoCredito.setVlEstorno(dto.getVlEstorno());
            estornoTipoAtualizacaoCredito.setDsMotivo(dto.getDsMotivo());
            estornoTipoAtualizacaoCredito.setIdTipoCredito(dto.getIdTipoCredito());
            estornoTipoAtualizacaoCredito.setIdTipoAtualizacaoCredito(dto.getIdTipoAtualizacaoCredito());
            this.estornoAtualizacaoCreditoRepository.saveAndFlush((Object)estornoTipoAtualizacaoCredito);
            return nextVal;
        });
        if (!Objects.equals(dto.getIdCreditoContribuinteItem(), 0L)) {
            EstornoAtualizacaoMonetariaCreditoContribuinteId id = new EstornoAtualizacaoMonetariaCreditoContribuinteId();
            id.setEstornoAtualizacaoMonetariaCredito((EstornoAtualizacaoMonetariaCredito)this.entityManager.getReference(EstornoAtualizacaoMonetariaCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)dto.getIdCreditoContribuinteItem()));
            id.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
            EstornoAtualizacaoMonetariaCreditoContribuinte estornoCredito = new EstornoAtualizacaoMonetariaCreditoContribuinte();
            estornoCredito.setId(id);
            estornoCredito.setValor(dto.getVlEstorno());
            return estornoCredito;
        }
        if (!Objects.equals(dto.getIdPagamentoBloqueto(), 0L)) {
            PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
            pagamentoDebitoId.setIdPagamentoBoleto(dto.getIdPagamentoBloqueto());
            pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
            EstornoAtualizacaoMonetariaPagamentoId id = new EstornoAtualizacaoMonetariaPagamentoId();
            id.setEstornoAtualizacaoMonetariaCredito((EstornoAtualizacaoMonetariaCredito)this.entityManager.getReference(EstornoAtualizacaoMonetariaCredito.class, (Object)finalId));
            id.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
            EstornoAtualizacaoMonetariaPagamento pagamento = new EstornoAtualizacaoMonetariaPagamento();
            pagamento.setId(id);
            pagamento.setValor(dto.getVlEstorno());
            return pagamento;
        }
        if (!Objects.equals(dto.getIdEstornoReajuste(), 0L)) {
            EstornoAtualizacaoMonetariaReajusteId id = new EstornoAtualizacaoMonetariaReajusteId();
            id.setIdEstornoAtualizacaoMonetariaCredito(finalId);
            id.setIdDebitoParcelaReceita(dto.getIdDebitoParcelaReceita());
            id.setIdEstornoReajuste(dto.getIdEstornoReajuste());
            id.setIdReajuste(dto.getIdReajuste());
            EstornoAtualizacaoMonetariaReajuste reajuste = new EstornoAtualizacaoMonetariaReajuste();
            reajuste.setId(id);
            reajuste.setValor(dto.getVlEstorno());
            return reajuste;
        }
        EstornoAtualizacaoCreditoParcelamentoId parcelamentoId = new EstornoAtualizacaoCreditoParcelamentoId();
        parcelamentoId.setIdParcelamento(dto.getIdParcelamento());
        parcelamentoId.setIdEstornoParcelamento(dto.getIdEstornoParcelamento());
        parcelamentoId.setIdDebitoParcelaReceita(dto.getIdDebitoParcelaReceita());
        parcelamentoId.setEstornoAtualizacaoMonetariaCredito(finalId);
        EstornoAtualizacaoCreditoParcelamento parcelamento = new EstornoAtualizacaoCreditoParcelamento();
        parcelamento.setId(parcelamentoId);
        parcelamento.setValor(dto.getVlEstorno());
        return parcelamento;
    }

    @OnProcessError
    public void onProcessError(EstornoAtualizacaoCreditoConsultaDTO item, Exception e) throws JsonProcessingException {
        log.error("SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public EstornoAtualizacaoCreditoBatchProcessor(EstornoAtualizacaoCreditoRepository estornoAtualizacaoCreditoRepository, SequenceGeneratorRepository sequenceGeneratorRepository, EntityManager entityManager, ObjectMapper objectMapper) {
        this.estornoAtualizacaoCreditoRepository = estornoAtualizacaoCreditoRepository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.entityManager = entityManager;
        this.objectMapper = objectMapper;
    }
}

