/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito.dividaativa;

import br.com.elotech.tributos.domain.simam.DeducaoCancelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoReabilitadoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoReabilitacaoParcelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.TipoDeducaoDividaAtiva;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCancelamentoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoPagamentoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoPagamentoReabilitadoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoParcelamentoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class DeducaoCreditoDividaAtivaBatchWriter
implements ItemWriter<TipoDeducaoDividaAtiva> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeducaoCreditoDividaAtivaBatchWriter.class);
    private final EntityManager entityManager;
    private final DeducaoCreditoCancelamentoDividaAtivaRepository deducaoCreditoCancelamentoDividaAtivaRepository;
    private final DeducaoCreditoPagamentoDividaAtivaRepository deducaoCreditoPagamentoDividaAtivaRepository;
    private final DeducaoCreditoCreditoDividaAtivaRepository deducaoCreditoCreditoDividaAtivaRepository;
    private final DeducaoCreditoParcelamentoDividaAtivaRepository deducaoCreditoParcelamentoDividaAtivaRepository;
    private final DeducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository deducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository;
    private final DeducaoCreditoPagamentoReabilitadoDividaAtivaRepository deducaoCreditoPagamentoReabilitadoDividaAtivaRepository;
    private StepExecution stepExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends TipoDeducaoDividaAtiva> items) throws Exception {
        List cancelamentos = items.stream().filter(DeducaoCancelamentoDividaAtiva.class::isInstance).map(DeducaoCancelamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(DeducaoPagamentoDividaAtiva.class::isInstance).map(DeducaoPagamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List creditos = items.stream().filter(DeducaoCreditoCreditoDividaAtiva.class::isInstance).map(DeducaoCreditoCreditoDividaAtiva.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(DeducaoParcelamentoDividaAtiva.class::isInstance).map(DeducaoParcelamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List reabilitacaoParcelamentos = items.stream().filter(DeducaoReabilitacaoParcelamentoDividaAtiva.class::isInstance).map(DeducaoReabilitacaoParcelamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List pagamentosReabilitados = items.stream().filter(DeducaoPagamentoReabilitadoDividaAtiva.class::isInstance).map(DeducaoPagamentoReabilitadoDividaAtiva.class::cast).collect(Collectors.toList());
        this.deducaoCreditoCancelamentoDividaAtivaRepository.saveAll(cancelamentos);
        this.deducaoCreditoPagamentoDividaAtivaRepository.saveAll(pagamentos);
        this.deducaoCreditoCreditoDividaAtivaRepository.saveAll(creditos);
        this.deducaoCreditoParcelamentoDividaAtivaRepository.saveAll(parcelamentos);
        this.deducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository.saveAll(reabilitacaoParcelamentos);
        this.deducaoCreditoPagamentoReabilitadoDividaAtivaRepository.saveAll(pagamentosReabilitados);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoDeducaoDividaAtiva> items) {
        log.info("SIM-AM - Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    @Generated
    public DeducaoCreditoDividaAtivaBatchWriter(EntityManager entityManager, DeducaoCreditoCancelamentoDividaAtivaRepository deducaoCreditoCancelamentoDividaAtivaRepository, DeducaoCreditoPagamentoDividaAtivaRepository deducaoCreditoPagamentoDividaAtivaRepository, DeducaoCreditoCreditoDividaAtivaRepository deducaoCreditoCreditoDividaAtivaRepository, DeducaoCreditoParcelamentoDividaAtivaRepository deducaoCreditoParcelamentoDividaAtivaRepository, DeducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository deducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository, DeducaoCreditoPagamentoReabilitadoDividaAtivaRepository deducaoCreditoPagamentoReabilitadoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.deducaoCreditoCancelamentoDividaAtivaRepository = deducaoCreditoCancelamentoDividaAtivaRepository;
        this.deducaoCreditoPagamentoDividaAtivaRepository = deducaoCreditoPagamentoDividaAtivaRepository;
        this.deducaoCreditoCreditoDividaAtivaRepository = deducaoCreditoCreditoDividaAtivaRepository;
        this.deducaoCreditoParcelamentoDividaAtivaRepository = deducaoCreditoParcelamentoDividaAtivaRepository;
        this.deducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository = deducaoCreditoReabilitacaoParcelamentoDividaAtivaRepository;
        this.deducaoCreditoPagamentoReabilitadoDividaAtivaRepository = deducaoCreditoPagamentoReabilitadoDividaAtivaRepository;
    }
}

