/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito;

import br.com.elotech.tributos.domain.simam.DeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoIsencao;
import br.com.elotech.tributos.domain.simam.DeducaoPagamento;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoReabilitado;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamento;
import br.com.elotech.tributos.domain.simam.DeducaoReabilitacaoParcelamento;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.TipoDeducaoCredito;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCancelamentoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCreditoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoIsencaoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoPagamentoReabilitadoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoPagamentoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoParcelamentoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoReabilitacaoParcelamentoRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class DeducaoCreditoBatchWriter
implements ItemWriter<TipoDeducaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeducaoCreditoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final DeducaoCreditoCancelamentoRepository deducaoCreditoCancelamentoRepository;
    private final DeducaoCreditoPagamentoRepository deducaoCreditoPagamentoRepository;
    private final DeducaoCreditoIsencaoRepository deducaoCreditoIsencaoRepository;
    private final DeducaoCreditoCreditoRepository deducaoCreditoCreditoRepository;
    private final DeducaoCreditoParcelamentoRepository deducaoCreditoParcelamentoRepository;
    private final DeducaoCreditoReabilitacaoParcelamentoRepository deducaoCreditoReabilitacaoParcelamentoRepository;
    private final DeducaoCreditoPagamentoReabilitadoRepository deducaoCreditoPagamentoReabilitadoRepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoDeducaoCredito> items) {
        List cancelamentos = items.stream().filter(DeducaoCancelamento.class::isInstance).map(DeducaoCancelamento.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(DeducaoPagamento.class::isInstance).map(DeducaoPagamento.class::cast).collect(Collectors.toList());
        List isencoes = items.stream().filter(DeducaoIsencao.class::isInstance).map(DeducaoIsencao.class::cast).collect(Collectors.toList());
        List creditos = items.stream().filter(DeducaoCreditoCredito.class::isInstance).map(DeducaoCreditoCredito.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(DeducaoParcelamento.class::isInstance).map(DeducaoParcelamento.class::cast).collect(Collectors.toList());
        List pagamentoReabilitados = items.stream().filter(DeducaoPagamentoReabilitado.class::isInstance).map(DeducaoPagamentoReabilitado.class::cast).collect(Collectors.toList());
        List reabilitacaoParcelamentos = items.stream().filter(DeducaoReabilitacaoParcelamento.class::isInstance).map(DeducaoReabilitacaoParcelamento.class::cast).collect(Collectors.toList());
        this.deducaoCreditoCancelamentoRepository.saveAll(cancelamentos);
        this.deducaoCreditoPagamentoRepository.saveAll(pagamentos);
        this.deducaoCreditoIsencaoRepository.saveAll(isencoes);
        this.deducaoCreditoCreditoRepository.saveAll(creditos);
        this.deducaoCreditoParcelamentoRepository.saveAll(parcelamentos);
        this.deducaoCreditoReabilitacaoParcelamentoRepository.saveAll(reabilitacaoParcelamentos);
        this.deducaoCreditoPagamentoReabilitadoRepository.saveAll(pagamentoReabilitados);
        this.entityManager.flush();
    }

    @Generated
    public DeducaoCreditoBatchWriter(EntityManager entityManager, DeducaoCreditoCancelamentoRepository deducaoCreditoCancelamentoRepository, DeducaoCreditoPagamentoRepository deducaoCreditoPagamentoRepository, DeducaoCreditoIsencaoRepository deducaoCreditoIsencaoRepository, DeducaoCreditoCreditoRepository deducaoCreditoCreditoRepository, DeducaoCreditoParcelamentoRepository deducaoCreditoParcelamentoRepository, DeducaoCreditoReabilitacaoParcelamentoRepository deducaoCreditoReabilitacaoParcelamentoRepository, DeducaoCreditoPagamentoReabilitadoRepository deducaoCreditoPagamentoReabilitadoRepository) {
        this.entityManager = entityManager;
        this.deducaoCreditoCancelamentoRepository = deducaoCreditoCancelamentoRepository;
        this.deducaoCreditoPagamentoRepository = deducaoCreditoPagamentoRepository;
        this.deducaoCreditoIsencaoRepository = deducaoCreditoIsencaoRepository;
        this.deducaoCreditoCreditoRepository = deducaoCreditoCreditoRepository;
        this.deducaoCreditoParcelamentoRepository = deducaoCreditoParcelamentoRepository;
        this.deducaoCreditoReabilitacaoParcelamentoRepository = deducaoCreditoReabilitacaoParcelamentoRepository;
        this.deducaoCreditoPagamentoReabilitadoRepository = deducaoCreditoPagamentoReabilitadoRepository;
    }
}

