/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoPagamentoReabilitadoDa;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitadoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajusteDA;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoCreditoDARepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoPagamentoDARepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoParcelamentoDARepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaReajusteDARepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class AtualizacaoMonetariaCreditoDABatchWriter
implements ItemWriter<TipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoMonetariaCreditoDABatchWriter.class);
    private static String PREFIXO = "SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final AtualizacaoMonetariaCreditoCreditoDARepository atualizacaoMonetariaCreditoCreditoDARepository;
    private final AtualizacaoMonetariaCreditoPagamentoDARepository atualizacaoMonetariaCreditoPagamentoDARepository;
    private final AtualizacaoMonetariaCreditoParcelamentoDARepository atualizacaoMonetariaCreditoParcelamentoDARepository;
    private final AtualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository atualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository;
    private final AtualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository atualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository;
    private final AtualizacaoMonetariaReajusteDARepository atualizacaoMonetariaReajusteDARepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info(PREFIXO + "Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoAtualizacaoMonetariaCreditoDA> items) {
        List creditos = items.stream().filter(item -> item instanceof AtualizacaoMonetariaCreditoCreditoDA).map(AtualizacaoMonetariaCreditoCreditoDA.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(item -> item instanceof AtualizacaoMonetariaPagamentoDA).map(AtualizacaoMonetariaPagamentoDA.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(item -> item instanceof AtualizacaoMonetariaCreditoParcelamentoDA).map(AtualizacaoMonetariaCreditoParcelamentoDA.class::cast).collect(Collectors.toList());
        List pagamentosReabilitados = items.stream().filter(AtualizacaoMonetariaCreditoPagamentoReabilitadoDa.class::isInstance).map(AtualizacaoMonetariaCreditoPagamentoReabilitadoDa.class::cast).collect(Collectors.toList());
        List parcelamentosReabilitados = items.stream().filter(AtualizacaoMonetariaCreditoParcelamentoReabilitadoDA.class::isInstance).map(AtualizacaoMonetariaCreditoParcelamentoReabilitadoDA.class::cast).collect(Collectors.toList());
        List reajustes = items.stream().filter(AtualizacaoMonetariaReajusteDA.class::isInstance).map(AtualizacaoMonetariaReajusteDA.class::cast).collect(Collectors.toList());
        this.atualizacaoMonetariaCreditoCreditoDARepository.saveAll(creditos);
        this.atualizacaoMonetariaCreditoPagamentoDARepository.saveAll(pagamentos);
        this.atualizacaoMonetariaCreditoParcelamentoDARepository.saveAll(parcelamentos);
        this.atualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository.saveAll(pagamentosReabilitados);
        this.atualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository.saveAll(parcelamentosReabilitados);
        this.atualizacaoMonetariaReajusteDARepository.saveAll(reajustes);
        this.entityManager.flush();
    }

    @Generated
    public AtualizacaoMonetariaCreditoDABatchWriter(EntityManager entityManager, AtualizacaoMonetariaCreditoCreditoDARepository atualizacaoMonetariaCreditoCreditoDARepository, AtualizacaoMonetariaCreditoPagamentoDARepository atualizacaoMonetariaCreditoPagamentoDARepository, AtualizacaoMonetariaCreditoParcelamentoDARepository atualizacaoMonetariaCreditoParcelamentoDARepository, AtualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository atualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository, AtualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository atualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository, AtualizacaoMonetariaReajusteDARepository atualizacaoMonetariaReajusteDARepository) {
        this.entityManager = entityManager;
        this.atualizacaoMonetariaCreditoCreditoDARepository = atualizacaoMonetariaCreditoCreditoDARepository;
        this.atualizacaoMonetariaCreditoPagamentoDARepository = atualizacaoMonetariaCreditoPagamentoDARepository;
        this.atualizacaoMonetariaCreditoParcelamentoDARepository = atualizacaoMonetariaCreditoParcelamentoDARepository;
        this.atualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository = atualizacaoMonetariaCreditoPagamentoReabilitadoDaRepository;
        this.atualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository = atualizacaoMonetariaCreditoParcelamentoReabilitadoDARepository;
        this.atualizacaoMonetariaReajusteDARepository = atualizacaoMonetariaReajusteDARepository;
    }
}

