/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoCreditoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoPagamentoReabilitadoDa;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitadoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitadoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoDAId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajusteDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajusteDAId;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaCreditoDAConsultaDTO;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

@Component
@StepScope
public class AtualizacaoMonetariaCreditoDABatchProcessor
implements ItemProcessor<AtualizacaoMonetariaCreditoDAConsultaDTO, TipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoMonetariaCreditoDABatchProcessor.class);
    private static String PREFIXO = "SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private AtomicLong ultimoNrAtualizacao = new AtomicLong(0L);
    @Autowired
    private PlatformTransactionManager transactionManager;
    private Long nrAnoAtualizacao;
    private StepExecution stepExecution;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        this.doInTransaction(() -> {
            LOGGER.info(PREFIXO + "Limpando tabela tempor\u00e1ria");
            this.atualizacaoMonetariaCreditoDARepository.limparTabelaTemporaria();
            LOGGER.info(PREFIXO + "Inserindo registros na tabela tempor\u00e1ria");
            this.atualizacaoMonetariaCreditoDARepository.preencherTabelaTemporaria(dataInicial, dataFinal);
        });
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoAtualizacao = dataInicial.getYear();
        LOGGER.info(PREFIXO + "load da carga existente");
        this.atualizacaoMonetariaCreditoDARepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizamoneCredDA()));
        LOGGER.info(PREFIXO + "Atualizando \u00faltimo NrAtualizacao");
        this.ultimoNrAtualizacao.set(this.atualizacaoMonetariaCreditoDARepository.findNextNrAtualizacaoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    private void doInTransaction(Runnable runnable) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
        runnable.run();
        this.transactionManager.commit(transaction);
    }

    public TipoAtualizacaoMonetariaCreditoDA process(AtualizacaoMonetariaCreditoDAConsultaDTO consulta) {
        String chave = String.format("%d-%d-%d-%s-%d-%d", consulta.getIdTipoAtualizacaoCredito(), consulta.getNrdivida(), consulta.getNranodivida(), consulta.getDtAtualizacao().toString(), consulta.getCdControleLeiAto(), consulta.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECREDDA");
            AtualizacaoMonetariaCreditoDA atualizacao = new AtualizacaoMonetariaCreditoDA();
            atualizacao.setId(nextId);
            atualizacao.setDtAtualizacao(consulta.getDtAtualizacao());
            atualizacao.setIdTipoAtualizacaoCredito(consulta.getIdTipoAtualizacaoCredito());
            atualizacao.setNrAtualizacao(Long.valueOf(this.ultimoNrAtualizacao.getAndIncrement()));
            atualizacao.setNrAnoAtualizacao(this.nrAnoAtualizacao);
            atualizacao.setNrDivida(consulta.getNrdivida());
            atualizacao.setNrAnoDivida(consulta.getNranodivida());
            atualizacao.setCdControleLeiAto(consulta.getCdControleLeiAto());
            atualizacao.setVlAtualizacao(BigDecimal.ZERO);
            atualizacao.setNrDivida(consulta.getNrdivida());
            atualizacao.setNrAnoDivida(consulta.getNranodivida());
            atualizacao.setCdControleLeiAto(consulta.getCdControleLeiAto());
            atualizacao.setIdTipoCredito(consulta.getIdTipoCredito());
            LOGGER.info(PREFIXO + "Gerando novo registro -> {} ({}/{})", new Object[]{nextId, atualizacao.getNrAtualizacao(), atualizacao.getNrAnoAtualizacao()});
            this.atualizacaoMonetariaCreditoDARepository.saveAndFlush((Object)atualizacao);
            return nextId;
        });
        AtualizacaoMonetariaCreditoDA atualizacaoMonetariaDA = (AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId);
        atualizacaoMonetariaDA.setVlAtualizacao(atualizacaoMonetariaDA.getVlAtualizacao().add(consulta.getVlAtualizacao()));
        if (consulta.isCreditoContribuinte()) {
            AtualizacaoMonetariaCreditoCreditoDAId id = new AtualizacaoMonetariaCreditoCreditoDAId();
            id.setAtualizacaoMonetariaCreditoDA((AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)consulta.getIdCreditoContribuinteItem()));
            id.setIdDebitoParcelaReceita(consulta.getIddebitoparcelareceita());
            return new AtualizacaoMonetariaCreditoCreditoDA(id, consulta.getVlAtualizacao());
        }
        if (consulta.isPagamento()) {
            AtualizacaoMonetariaPagamentoDAId id = new AtualizacaoMonetariaPagamentoDAId();
            id.setAtualizacaoMonetariaCreditoDA((AtualizacaoMonetariaCreditoDA)this.entityManager.getReference(AtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdDebitoParcelaReceita(consulta.getIddebitoparcelareceita());
            id.setIdPagamentoBloqueto(consulta.getIdpagamentobloqueto());
            return new AtualizacaoMonetariaPagamentoDA(id, consulta.getVlAtualizacao());
        }
        if (consulta.isEstornoParcelamento()) {
            AtualizacaoMonetariaCreditoParcelamentoReabilitadoDAId id = new AtualizacaoMonetariaCreditoParcelamentoReabilitadoDAId();
            id.setAtualizacaoMonetariaCreditoDA(finalId);
            id.setIdEstornoParcelamento(consulta.getIdEstornoParcelamento());
            id.setIdDebitoParcelaReceita(consulta.getIddebitoparcelareceita());
            id.setTipoAtualizacaoCredito(consulta.getIdTipoAtualizacaoCredito());
            return new AtualizacaoMonetariaCreditoParcelamentoReabilitadoDA(id, consulta.getVlAtualizacao());
        }
        if (consulta.isReajuste()) {
            AtualizacaoMonetariaReajusteDAId id = AtualizacaoMonetariaReajusteDAId.builder().idAtualizacaoMonetariaDA(finalId).idReajuste(consulta.getIdReajuste()).idDebitoParcelaReceita(consulta.getIddebitoparcelareceita()).build();
            return new AtualizacaoMonetariaReajusteDA(id, consulta.getVlAtualizacao());
        }
        if (consulta.isParcelamento()) {
            AtualizacaoMonetariaCreditoParcelamentoDAId id = new AtualizacaoMonetariaCreditoParcelamentoDAId();
            id.setIdParcelamento(consulta.getIdParcelamento());
            id.setAtualizacaoMonetariaCreditoDA(finalId);
            id.setIdDebitoParcelaReceita(consulta.getIddebitoparcelareceita());
            return new AtualizacaoMonetariaCreditoParcelamentoDA(id, consulta.getVlAtualizacao());
        }
        if (consulta.isPagamentoReabilitado()) {
            return AtualizacaoMonetariaCreditoPagamentoReabilitadoDa.from((AtualizacaoMonetariaCreditoDAConsultaDTO)consulta).withIdAtualizaMoneCredDaAs(finalId);
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws JsonProcessingException {
        LOGGER.error("Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public AtualizacaoMonetariaCreditoDABatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.atualizacaoMonetariaCreditoDARepository = atualizacaoMonetariaCreditoDARepository;
        this.objectMapper = objectMapper;
    }
}

