/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaocredito;

import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamento;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitado;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamento;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoReabilitado;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajuste;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoCredito;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoContribuinteRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoParcelamentoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaPagamentoReabilitadoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaPagamentoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaParcelamentoReabilitadoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaReajusteRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class AtualizacaoCreditoBatchWriter
implements ItemWriter<TipoAtualizacaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoCreditoBatchWriter.class);
    private StepExecution stepExecution;
    private final AtualizacaoMonetariaPagamentoRepository atualizacaoMonetariaPagamentoRepository;
    private final AtualizacaoMonetariaCreditoContribuinteRepository atualizacaoMonetariaCreditoContribuinteRepository;
    private final AtualizacaoMonetariaCreditoParcelamentoRepository atualizacaoMonetariaCreditoParcelamentoRepository;
    private final AtualizacaoMonetariaPagamentoReabilitadoRepository atualizacaoMonetariaPagamentoReabilitadoRepository;
    private final AtualizacaoMonetariaParcelamentoReabilitadoRepository atualizacaoMonetariaParcelamentoReabilitadoRepository;
    private final AtualizacaoMonetariaReajusteRepository atualizacaoMonetariaReajusteRepository;
    private final EntityManager entityManager;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends TipoAtualizacaoCredito> items) throws Exception {
        List creditos = items.stream().filter(AtualizacaoMonetariaCreditoContribuinte.class::isInstance).map(AtualizacaoMonetariaCreditoContribuinte.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(AtualizacaoMonetariaPagamento.class::isInstance).map(AtualizacaoMonetariaPagamento.class::cast).collect(Collectors.toList());
        List parcelamentos = items.stream().filter(AtualizacaoMonetariaCreditoParcelamento.class::isInstance).map(AtualizacaoMonetariaCreditoParcelamento.class::cast).collect(Collectors.toList());
        List reabilitacaoPagamentos = items.stream().filter(AtualizacaoMonetariaPagamentoReabilitado.class::isInstance).map(AtualizacaoMonetariaPagamentoReabilitado.class::cast).collect(Collectors.toList());
        List reabilitacaoParcelamentos = items.stream().filter(AtualizacaoMonetariaCreditoParcelamentoReabilitado.class::isInstance).map(AtualizacaoMonetariaCreditoParcelamentoReabilitado.class::cast).collect(Collectors.toList());
        List reajustes = items.stream().filter(AtualizacaoMonetariaReajuste.class::isInstance).map(AtualizacaoMonetariaReajuste.class::cast).collect(Collectors.toList());
        this.atualizacaoMonetariaCreditoContribuinteRepository.saveAll(creditos);
        this.atualizacaoMonetariaPagamentoRepository.saveAll(pagamentos);
        this.atualizacaoMonetariaCreditoParcelamentoRepository.saveAll(parcelamentos);
        this.atualizacaoMonetariaPagamentoReabilitadoRepository.saveAll(reabilitacaoPagamentos);
        this.atualizacaoMonetariaParcelamentoReabilitadoRepository.saveAll(reabilitacaoParcelamentos);
        this.atualizacaoMonetariaReajusteRepository.saveAll(reajustes);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoAtualizacaoCredito> items) {
        log.info("SIM-AM - Atualiza\u00e7\u00e3o de Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    @Generated
    public AtualizacaoCreditoBatchWriter(AtualizacaoMonetariaPagamentoRepository atualizacaoMonetariaPagamentoRepository, AtualizacaoMonetariaCreditoContribuinteRepository atualizacaoMonetariaCreditoContribuinteRepository, AtualizacaoMonetariaCreditoParcelamentoRepository atualizacaoMonetariaCreditoParcelamentoRepository, AtualizacaoMonetariaPagamentoReabilitadoRepository atualizacaoMonetariaPagamentoReabilitadoRepository, AtualizacaoMonetariaParcelamentoReabilitadoRepository atualizacaoMonetariaParcelamentoReabilitadoRepository, AtualizacaoMonetariaReajusteRepository atualizacaoMonetariaReajusteRepository, EntityManager entityManager) {
        this.atualizacaoMonetariaPagamentoRepository = atualizacaoMonetariaPagamentoRepository;
        this.atualizacaoMonetariaCreditoContribuinteRepository = atualizacaoMonetariaCreditoContribuinteRepository;
        this.atualizacaoMonetariaCreditoParcelamentoRepository = atualizacaoMonetariaCreditoParcelamentoRepository;
        this.atualizacaoMonetariaPagamentoReabilitadoRepository = atualizacaoMonetariaPagamentoReabilitadoRepository;
        this.atualizacaoMonetariaParcelamentoReabilitadoRepository = atualizacaoMonetariaParcelamentoReabilitadoRepository;
        this.atualizacaoMonetariaReajusteRepository = atualizacaoMonetariaReajusteRepository;
        this.entityManager = entityManager;
    }
}

