/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaocredito;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.simam.AtualizacaoCreditoParcelamentoId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCredito;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoContribuinteId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamento;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitado;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoReabilitadoId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamento;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaPagamentoReabilitado;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajuste;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaReajusteId;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoCredito;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoConsultaDTO;
import br.com.elotech.tributos.enums.TipoAtualizacaoCreditoSimAm;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoCreditoBatchProcessor
implements ItemProcessor<AtualizacaoCreditoConsultaDTO, TipoAtualizacaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoCreditoBatchProcessor.class);
    private static final String ATUALIZACAO_CREDITO = "SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - ";
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository;
    private final EntityManager entityManager;
    private final AtualizacaoCreditoRepository atualizacaoCreditoRepository;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong nrAtualizacao = new AtomicLong(0L);
    private final ObjectMapper objectMapper;
    private Long nrAnoAtualizacao;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        this.nrAnoAtualizacao = dataInicial.getYear();
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - load da carga existente");
        this.atualizacaoCreditoRepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizaMoneCred()));
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - atualizando \u00faltimo nrAtualizacao");
        this.nrAtualizacao.set(this.atualizacaoMonetariaCreditoRepository.getNrAtualizacao(this.nrAnoAtualizacao));
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
    }

    public TipoAtualizacaoCredito process(AtualizacaoCreditoConsultaDTO consulta) throws Exception {
        String chave = String.format("%d-%d-%d-%s-%d-%d-%d", consulta.getIdTipoAtualizacaoCredito(), consulta.getNrCredito(), consulta.getNrAnoCredito(), consulta.getDtAtualizacao().toString(), consulta.getCdControleLeiAto(), consulta.getIdTipoAtualizacaoCredito(), consulta.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECRED");
            AtualizacaoMonetariaCredito atualizacaoMonetaria = new AtualizacaoMonetariaCredito();
            atualizacaoMonetaria.setId(nextVal);
            atualizacaoMonetaria.setNrAtualizacao(Long.valueOf(this.nrAtualizacao.getAndIncrement()));
            atualizacaoMonetaria.setNrAnoAtualizacao(this.nrAnoAtualizacao);
            atualizacaoMonetaria.setTipoAtualizacaoCredito(TipoAtualizacaoCreditoSimAm.fromValue((Long)consulta.getIdTipoAtualizacaoCredito()));
            atualizacaoMonetaria.setDtAtualizacao(consulta.getDtAtualizacao());
            atualizacaoMonetaria.setVlAtualizacao(BigDecimal.ZERO);
            atualizacaoMonetaria.setNrCredito(consulta.getNrCredito());
            atualizacaoMonetaria.setNrAnoCredito(consulta.getNrAnoCredito());
            atualizacaoMonetaria.setCdControleLeiAto(consulta.getCdControleLeiAto());
            atualizacaoMonetaria.setNrCredito(consulta.getNrCredito());
            atualizacaoMonetaria.setNrAnoCredito(consulta.getNrAnoCredito());
            atualizacaoMonetaria.setCdControleLeiAto(consulta.getCdControleLeiAto());
            atualizacaoMonetaria.setIdTipoCredito(consulta.getIdTipoCredito());
            log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - gerando novo registro -> {} ({}/{})", new Object[]{nextVal, this.nrAtualizacao, this.nrAnoAtualizacao});
            this.atualizacaoCreditoRepository.saveAndFlush((Object)atualizacaoMonetaria);
            return nextVal;
        });
        AtualizacaoMonetariaCredito atualizacaoMonetaria = (AtualizacaoMonetariaCredito)this.entityManager.getReference(AtualizacaoMonetariaCredito.class, (Object)finalId);
        atualizacaoMonetaria.setVlAtualizacao(atualizacaoMonetaria.getVlAtualizacao().add(consulta.getVlAtualizacao()));
        this.atualizacaoCreditoRepository.saveAndFlush((Object)atualizacaoMonetaria);
        if (consulta.isCreditoContribuinte()) {
            AtualizacaoMonetariaCreditoContribuinteId id = new AtualizacaoMonetariaCreditoContribuinteId();
            id.setAtualizacaoMonetariaCredito(atualizacaoMonetaria);
            id.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)consulta.getIdCreditoContribuinteItem()));
            id.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)consulta.getIdDebitoParcelaReceita()));
            AtualizacaoMonetariaCreditoContribuinte credito = new AtualizacaoMonetariaCreditoContribuinte();
            credito.setId(id);
            credito.setValor(consulta.getVlAtualizacao());
            return credito;
        }
        if (consulta.isPagamento()) {
            PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
            pagamentoDebitoId.setIdPagamentoBoleto(consulta.getIdPagamentoBloqueto());
            pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)consulta.getIdDebitoParcelaReceita()));
            AtualizacaoMonetariaPagamentoId id = new AtualizacaoMonetariaPagamentoId();
            id.setAtualizacaoMonetariaCredito(atualizacaoMonetaria);
            id.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
            AtualizacaoMonetariaPagamento pagamento = new AtualizacaoMonetariaPagamento();
            pagamento.setId(id);
            pagamento.setValor(consulta.getVlAtualizacao());
            return pagamento;
        }
        if (consulta.isReajuste()) {
            AtualizacaoMonetariaReajusteId id = new AtualizacaoMonetariaReajusteId();
            id.setIdAtualizacaoMonetaria(atualizacaoMonetaria.getId());
            id.setIdReajuste(consulta.getIdReajuste());
            id.setIdDebitoParcelaReceita(consulta.getIdDebitoParcelaReceita());
            AtualizacaoMonetariaReajuste reajuste = new AtualizacaoMonetariaReajuste();
            reajuste.setId(id);
            reajuste.setValor(consulta.getVlAtualizacao());
            return reajuste;
        }
        if (consulta.isEstornoParcelamento()) {
            AtualizacaoMonetariaCreditoParcelamentoReabilitadoId parcelamentoId = new AtualizacaoMonetariaCreditoParcelamentoReabilitadoId();
            parcelamentoId.setAtualizacaoMonetariaCredito(atualizacaoMonetaria.getId());
            parcelamentoId.setIdEstornoParcelamento(consulta.getIdEstornoParcelamento());
            parcelamentoId.setTipoAtualizacaoCredito(consulta.getIdTipoAtualizacaoCredito());
            parcelamentoId.setIdDebitoParcelaReceita(consulta.getIdDebitoParcelaReceita());
            AtualizacaoMonetariaCreditoParcelamentoReabilitado parcelamento = new AtualizacaoMonetariaCreditoParcelamentoReabilitado();
            parcelamento.setId(parcelamentoId);
            parcelamento.setValor(consulta.getVlAtualizacao());
            return parcelamento;
        }
        if (consulta.isParcelamento()) {
            AtualizacaoCreditoParcelamentoId parcelamentoId = new AtualizacaoCreditoParcelamentoId();
            parcelamentoId.setAtualizacaoMonetariaCredito(atualizacaoMonetaria.getId());
            parcelamentoId.setIdParcelamento(consulta.getIdParcelamento());
            parcelamentoId.setIdDebitoParcelaReceita(consulta.getIdDebitoParcelaReceita());
            AtualizacaoMonetariaCreditoParcelamento parcelamento = new AtualizacaoMonetariaCreditoParcelamento();
            parcelamento.setId(parcelamentoId);
            parcelamento.setValor(consulta.getVlAtualizacao());
            return parcelamento;
        }
        if (consulta.isPagamentoReabilitado()) {
            return AtualizacaoMonetariaPagamentoReabilitado.from((AtualizacaoCreditoConsultaDTO)consulta).withIdTceAtualizaMoneCredAs(finalId);
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(Object item, Exception e) throws Exception {
        log.error("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString(item));
    }

    @Generated
    public AtualizacaoCreditoBatchProcessor(SequenceGeneratorRepository sequenceGeneratorRepository, AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository, EntityManager entityManager, AtualizacaoCreditoRepository atualizacaoCreditoRepository, ObjectMapper objectMapper) {
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.atualizacaoMonetariaCreditoRepository = atualizacaoMonetariaCreditoRepository;
        this.entityManager = entityManager;
        this.atualizacaoCreditoRepository = atualizacaoCreditoRepository;
        this.objectMapper = objectMapper;
    }
}

