/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.arrecadacaocredito;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCredito;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoCreditoContribuinteId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoDevolucao;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoDevolucaoId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamento;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamentoId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamentoReabilitado;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoRetencaoContabil;
import br.com.elotech.tributos.domain.simam.TipoArrecadacaoCredito;
import br.com.elotech.tributos.dto.TipoArrecadacao;
import br.com.elotech.tributos.dto.diarioarrecadacao.TipoOrigemReceita;
import br.com.elotech.tributos.dto.simam.ArrecadacaoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ArrecadacaoCreditoBatchProcessor
implements ItemProcessor<ArrecadacaoCreditoConsultaDTO, TipoArrecadacaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrecadacaoCreditoBatchProcessor.class);
    private static final String PREFIXO = "SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - ";
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong ultimoNrArrecadacao = new AtomicLong(0L);
    private Long nrAnoArrecadacao;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ArrecadacaoCreditoRepository arrecadacaoCreditoRepository;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoArrecadacao = dataInicial.getYear();
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Atualizando \u00faltimo NrArrecadacao");
        this.ultimoNrArrecadacao.set(this.arrecadacaoCreditoRepository.findNextNrArrecadacaoByExercicio(this.nrAnoArrecadacao));
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - load da carga existente");
        this.arrecadacaoCreditoRepository.getCargaExistente(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceArrTipoCredito()));
    }

    public TipoArrecadacaoCredito process(ArrecadacaoCreditoConsultaDTO consulta) {
        String chave = String.format("%d-%d-%d-%d-%d-%d-%d-%d-%d-%d", this.nrAnoArrecadacao, consulta.getIdTipoOrigemReceita(), consulta.getIdTipoArrecadacao(), consulta.getNrCredito(), consulta.getNrAnoCredito(), consulta.getNrDivida(), consulta.getNrAnoDivida(), consulta.getNrMes(), consulta.getNrAno(), consulta.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEARRTIPOCREDITO");
            ArrecadacaoCredito arrecadacaoCredito = new ArrecadacaoCredito();
            arrecadacaoCredito.setId(nextId);
            arrecadacaoCredito.setTipoOrigemReceita(TipoOrigemReceita.fromValue((Long)consulta.getIdTipoOrigemReceita()));
            arrecadacaoCredito.setTipoArrecadacao(TipoArrecadacao.fromValue((Long)consulta.getIdTipoArrecadacao()));
            arrecadacaoCredito.setNrAnoArrecadacao(this.nrAnoArrecadacao);
            arrecadacaoCredito.setNrArrecadacao(Long.valueOf(this.ultimoNrArrecadacao.getAndIncrement()));
            arrecadacaoCredito.setValorArrecadacao(consulta.getVlArrecadacao());
            arrecadacaoCredito.setNrCredito(consulta.getNrCredito());
            arrecadacaoCredito.setNrAnoCredito(consulta.getNrAnoCredito());
            arrecadacaoCredito.setNrDivida(consulta.getNrDivida());
            arrecadacaoCredito.setNrAnoDivida(consulta.getNrAnoDivida());
            arrecadacaoCredito.setNrMes(consulta.getNrMes());
            arrecadacaoCredito.setNrAno(consulta.getNrAno());
            arrecadacaoCredito.setIdTipoCredito(consulta.getIdTipoCredito());
            LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Gerando novo registro -> {} ({}/{})", new Object[]{nextId, arrecadacaoCredito.getNrArrecadacao(), arrecadacaoCredito.getNrAnoArrecadacao()});
            this.arrecadacaoCreditoRepository.save((Object)arrecadacaoCredito);
            this.entityManager.flush();
            return nextId;
        });
        if (consulta.isRetencaoContabil()) {
            ArrecadacaoCreditoRetencaoContabil retencaoContabil = new ArrecadacaoCreditoRetencaoContabil();
            retencaoContabil.setId(consulta.getIdRetencaoContabil());
            retencaoContabil.setIdTceArrTipoCredito(finalId);
            return retencaoContabil;
        }
        if (consulta.isCreditoContribuinte()) {
            ArrecadacaoCreditoCreditoContribuinteId id = new ArrecadacaoCreditoCreditoContribuinteId();
            id.setArrecadacaoCredito((ArrecadacaoCredito)this.entityManager.getReference(ArrecadacaoCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)consulta.getIdCreditoContribuinteItem()));
            id.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)consulta.getIdDebitoParcelaReceita()));
            return new ArrecadacaoCreditoCreditoContribuinte(id, consulta.getVlArrecadacao());
        }
        if (consulta.isDevolucaoCredito()) {
            ArrecadacaoCreditoDevolucaoId id = new ArrecadacaoCreditoDevolucaoId();
            id.setIdTceArrTipoCredito(finalId);
            id.setIdDevolucaoCredito(consulta.getIdDevolucaoCredito());
            id.setSequenciaItem(consulta.getSequenciaItem());
            id.setSequenciaDebito(consulta.getSequenciaDebito());
            return new ArrecadacaoCreditoDevolucao(id, consulta.getVlArrecadacao());
        }
        if (consulta.isReabilitacaoPagamento()) {
            return ArrecadacaoCreditoPagamentoReabilitado.from((ArrecadacaoCreditoConsultaDTO)consulta).withIdTceArrTipoCreditoAs(finalId);
        }
        ArrecadacaoCreditoPagamentoId id = new ArrecadacaoCreditoPagamentoId();
        id.setArrecadacaoCredito((ArrecadacaoCredito)this.entityManager.getReference(ArrecadacaoCredito.class, (Object)finalId));
        PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
        pagamentoDebitoId.setIdPagamentoBoleto(consulta.getIdPagamentoBloqueto());
        pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)consulta.getIdDebitoParcelaReceita()));
        id.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
        return new ArrecadacaoCreditoPagamento(id, consulta.getVlArrecadacao());
    }

    @OnProcessError
    public void onProcessError(ArrecadacaoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public ArrecadacaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, ArrecadacaoCreditoRepository arrecadacaoCreditoRepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.arrecadacaoCreditoRepository = arrecadacaoCreditoRepository;
        this.objectMapper = objectMapper;
    }
}

