/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.processamento;

import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.service.sanepar.ProcessamentoSaneparService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ProcessamentoSaneparProcessor
implements ItemProcessor<BaixaSaneparItem, BaixaSaneparItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSaneparProcessor.class);
    private final ProcessamentoSaneparService processamentoSaneparService;

    public BaixaSaneparItem process(BaixaSaneparItem item) {
        if (!item.getSituacao().permiteProcessarBaixa()) {
            return null;
        }
        log.debug(String.format("Processando item %s da linha %s e matricula %s", item.getId(), item.getLinha(), item.getMatricula()));
        this.processamentoSaneparService.processarBaixaBatch(item);
        return item;
    }

    @Generated
    public ProcessamentoSaneparProcessor(ProcessamentoSaneparService processamentoSaneparService) {
        this.processamentoSaneparService = processamentoSaneparService;
    }
}

