/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.processamento;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ProcessamentoSaneparJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSaneparJobListener.class);
    private final NotificacaoService notificacaoService;
    private final String notificationKey = "notificacaoId";
    private static final Map<NotificationStatus, String> notificationMessage = Map.of(NotificationStatus.STARTED, "Iniciando processamento do lote da sanepar %s ", NotificationStatus.COMPLETED, "Finalizado processamento do lote da sanepar %s", NotificationStatus.FAILED, "Erro no processamento do lote da sanepar %s");

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idBaixa = jobExecution.getJobParameters().getLong("idBaixa");
        Optional notificacaoId = this.notificaInicio(idBaixa, jobExecution);
        notificacaoId.ifPresent(id -> jobExecution.getExecutionContext().put("notificacaoId", id));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idBaixa = jobExecution.getJobParameters().getLong("idBaixa");
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificaFinalSuccess(idBaixa, jobExecution);
        } else {
            this.notificaFinalFailed(idBaixa, jobExecution);
        }
    }

    private Optional<UUID> notificaInicio(Long idBaixa, JobExecution jobExecution) {
        return this.notificar(idBaixa, jobExecution, NotificationStatus.STARTED);
    }

    private void notificaFinalSuccess(Long idBaixa, JobExecution jobExecution) {
        this.notificar(idBaixa, jobExecution, NotificationStatus.COMPLETED);
    }

    private void notificaFinalFailed(Long idBaixa, JobExecution jobExecution) {
        this.notificar(idBaixa, jobExecution, NotificationStatus.FAILED);
    }

    private Optional<UUID> notificar(Long idBaixa, JobExecution jobExecution, NotificationStatus status) {
        String message = String.format((String)notificationMessage.get(status), idBaixa);
        Optional<UUID> notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get("notificacaoId")).map(id -> UUID.fromString(String.valueOf(id)));
        return this.notificacaoService.send("Processamento do lote sanepar", message, jobExecution, notificacaoId, status);
    }

    @Generated
    public ProcessamentoSaneparJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

