/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacaoiss;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.relatoriogerencial.ArrecadacaoAnualMesDividaDTO;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoArrecadacaoIssReader
extends JdbcCursorItemReader<ArrecadacaoAnualMesDividaDTO> {
    public LancamentoArrecadacaoIssReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long mes = (Long)jobParameters.get("mes");
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), mes.intValue(), 1);
        LocalDate dataFinal = dataInicial.with(TemporalAdjusters.lastDayOfMonth());
        String sql = FileUtils.readResourceAsString((String)"sql/batch/relatoriogerencial/lancamentoarrecadacaoiss.sql").replace(":entidade", String.valueOf(entidade)).replace(":dataInicial", String.valueOf(dataInicial)).replace(":dataFinal", String.valueOf(dataFinal));
        this.setFetchSize(500);
        this.setName("lancamentoArrecadacaoIss");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoAnualMesDividaDTO.class));
        this.setSql(sql);
    }
}

