/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto.importacaoretornoremessa;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.RetornoRemessaItemDTO;
import br.com.elotech.tributos.enums.protestoremessa.RetornoRemessaItemField;
import br.com.elotech.tributos.repository.ProtestoRemessaItemRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoRetornoRemessaBatchReader
extends FlatFileItemReader<RetornoRemessaItemDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoRetornoRemessaBatchReader.class);
    private final ProtestoRemessaRepository protestoRemessaRepository;
    private final ProtestoRemessaItemRepository protestoRemessaItemRepository;
    private final ResolversHandler resolversHandler;
    private static final String HEADER_REGISTRO = "0";
    private static final String CONTEUDO_REGISTRO = "1";
    private static final String FOOTER_REGISTRO = "9";
    private final List<ProtestoRemessaItem> itensRemessa;
    private int indexAtual = 0;

    public ImportacaoRetornoRemessaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ResolversHandler resolversHandler, ProtestoRemessaRepository protestoRemessaRepository, ProtestoRemessaItemRepository protestoRemessaItemRepository) {
        this.protestoRemessaRepository = protestoRemessaRepository;
        this.protestoRemessaItemRepository = protestoRemessaItemRepository;
        this.resolversHandler = resolversHandler;
        Long idProtestoRemessa = (Long)jobParameters.get("idProtestoRemessa");
        ProtestoRemessa protestoRemessa = this.getProtestoRemessa(idProtestoRemessa);
        this.itensRemessa = this.getItens(protestoRemessa);
        this.setResource((Resource)new InputStreamResource(this.getFileStream(protestoRemessa)));
        this.setLineMapper((LineMapper)this.buildLineMapper());
    }

    public ProtestoRemessa getProtestoRemessa(Long idProtestoRemessa) {
        return (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)idProtestoRemessa).orElseThrow(() -> new EntityExistsException(String.format("Protesto de Remessa com ID %s n\u00e3o encontrado.", idProtestoRemessa)));
    }

    public byte[] getArquivoRetornoRemessa(ProtestoRemessa protestoRemessa) {
        ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + String.valueOf(protestoRemessa.getArqrecIdArquivo())));
        try {
            return ((ArquivoContent)this.resolveArquivoClient().buscarArquivo(arquivoFindRequest).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o arquivo de retorno remessa para o protesto remessa de id %d.", protestoRemessa.getId())))).getContent().readAllBytes();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao buscar arquivo de retorno remessa. " + e.getMessage());
        }
    }

    public InputStream getFileStream(ProtestoRemessa protestoRemessa) {
        byte[] arquivoBytes = this.getArquivoRetornoRemessa(protestoRemessa);
        return new ByteArrayInputStream(arquivoBytes);
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public DefaultLineMapper<RetornoRemessaItemDTO> buildLineMapper() {
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        lineMapper.setLineTokenizer(this.createLineTokenizer());
        lineMapper.setFieldSetMapper(arg_0 -> this.mapLineToDTO(arg_0));
        return lineMapper;
    }

    public RetornoRemessaItemDTO mapLineToDTO(FieldSet fieldSet) {
        String identificacaoRegistro;
        switch (identificacaoRegistro = fieldSet.readString(RetornoRemessaItemField.IDENTIFICACAO_REGISTRO.getFieldName())) {
            case "0": {
                return new RetornoRemessaItemDTO();
            }
            case "9": {
                return null;
            }
            case "1": {
                return this.buildRetornoRemessaItemDTO(fieldSet);
            }
        }
        throw new IllegalArgumentException("Tipo de linha desconhecido: " + identificacaoRegistro);
    }

    public LineTokenizer createLineTokenizer() {
        FixedLengthTokenizer tokenizer = new FixedLengthTokenizer();
        tokenizer.setNames(new String[]{RetornoRemessaItemField.IDENTIFICACAO_REGISTRO.getFieldName(), RetornoRemessaItemField.CODIGO_CARTORIO.getFieldName(), RetornoRemessaItemField.NUMERO_PROTOCOLO_CARTORIO.getFieldName(), RetornoRemessaItemField.TIPO_OCORRENCIA.getFieldName(), RetornoRemessaItemField.DATA_PROTOCOLO.getFieldName(), RetornoRemessaItemField.VALOR_CUSTAS_CARTORIO.getFieldName(), RetornoRemessaItemField.DATA_OCORRENCIA.getFieldName(), RetornoRemessaItemField.CODIGO_IRREGULARIDADE.getFieldName(), RetornoRemessaItemField.VALOR_CUSTAS_DISTRIBUIDOR.getFieldName(), RetornoRemessaItemField.IRREGULARIDADE_1.getFieldName(), RetornoRemessaItemField.IRREGULARIDADE_2.getFieldName(), RetornoRemessaItemField.IRREGULARIDADE_3.getFieldName(), RetornoRemessaItemField.IRREGULARIDADE_4.getFieldName(), RetornoRemessaItemField.VALOR_DEMAIS_DESPESAS.getFieldName(), RetornoRemessaItemField.NUMERO_SEQUENCIAL_REGISTRO.getFieldName()});
        tokenizer.setColumns(new Range[]{new Range(1, 1), new Range(466, 467), new Range(448, 457), new Range(458, 458), new Range(459, 466), new Range(467, 476), new Range(478, 485), new Range(486, 487), new Range(508, 517), new Range(558, 559), new Range(560, 561), new Range(562, 563), new Range(564, 565), new Range(566, 575), new Range(597, 600)});
        tokenizer.setStrict(false);
        return tokenizer;
    }

    public List<ProtestoRemessaItem> getItens(ProtestoRemessa protestoRemessa) {
        return this.protestoRemessaItemRepository.findByProtestoRemessa(protestoRemessa).stream().sorted(Comparator.comparingLong(ProtestoRemessaItem::getSequencia)).collect(Collectors.toList());
    }

    public RetornoRemessaItemDTO buildRetornoRemessaItemDTO(FieldSet fieldSet) {
        ProtestoRemessaItem protestoRemessaItemAtual = (ProtestoRemessaItem)this.itensRemessa.get(this.indexAtual);
        RetornoRemessaItemDTO retornoRemessaItemDTO = new RetornoRemessaItemDTO(protestoRemessaItemAtual.getId(), fieldSet);
        ++this.indexAtual;
        return retornoRemessaItemDTO;
    }
}

