/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class GerarProtestoRemessaJobListener
extends JobExecutionListenerSupport {
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final ParametroGeralService parametroGeralService;

    public void beforeJob(@Nullable JobExecution jobExecution) {
        String detail;
        String title;
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.beforeJob(jobExecution);
        String dataInicio = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        boolean utilizaWebServiceProtesto = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO);
        if (utilizaWebServiceProtesto) {
            title = "Protesto - Iniciado Envio de Remessa para o CRA";
            detail = String.format("Iniciado o processo para o envio da remessa de protestos para o CRA - %s", dataInicio);
        } else {
            title = "Protesto - Iniciado a Gera\u00e7\u00e3o da Remessa de Protestos";
            detail = String.format("Iniciado o processo para a cria\u00e7\u00e3o da remessa de protestos - %s", dataInicio);
        }
        Optional notificacaoId = this.notificacaoService.send(title, detail, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.afterJob(jobExecution);
        String dataFim = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        boolean utilizaWebServiceProtesto = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            String detail;
            String title;
            if (utilizaWebServiceProtesto) {
                title = "Protesto - Sucesso ao Enviar de Remessa para o CRA";
                detail = String.format("Finalizado com sucesso o envio da remessa de protestos para o CRA - %s", dataFim);
            } else {
                title = "Protesto - Sucesso ao Gerar a Remessa de Protestos";
                detail = String.format("Finalizado com sucesso a gera\u00e7\u00e3o da remessa de protestos - %s", dataFim);
            }
            this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
            return;
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            String detail;
            String title;
            if (utilizaWebServiceProtesto) {
                title = "Protesto - Erro ao Enviar de Remessa para o CRA";
                detail = String.format("Ocorreu algum erro no envio da remessa de protestos para o CRA - %s", dataFim);
            } else {
                title = "Protesto - Erro ao Gerar a Remessa de Protestos";
                detail = String.format("Ocorreu algum erro ao gerar a remessa de protestos - %s", dataFim);
            }
            this.notificacaoService.send(title, detail, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public GerarProtestoRemessaJobListener(NotificacaoService notificacaoService, ParametroGeralService parametroGeralService) {
        this.notificacaoService = notificacaoService;
        this.parametroGeralService = parametroGeralService;
    }
}

