/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.exportacaoconsultacsv;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ExportacaoConsultaCsvWriter
extends FlatFileItemWriter<Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportacaoConsultaCsvWriter.class);
    private long totalWritten = 0L;
    private String filename;

    public ExportacaoConsultaCsvWriter(String viewName, String filename, String tempDir, String delimitador, String[] columnNames) {
        this.filename = filename;
        this.setName("writer-" + viewName);
        this.setResource((Resource)new FileSystemResource(tempDir + filename));
        this.setLineAggregator((LineAggregator)new /* Unavailable Anonymous Inner Class!! */);
        this.setHeaderCallback(w -> w.write(String.join((CharSequence)this.normalizeDelimiter(delimitador), columnNames)));
        this.setShouldDeleteIfExists(true);
    }

    public void write(List<? extends Map<String, Object>> items) throws Exception {
        super.write(items);
        this.totalWritten += (long)items.size();
        log.debug(String.format("Escritas %d linhas no arquivo %s.", this.totalWritten, this.filename));
    }

    private String normalizeDelimiter(String delimitador) {
        return switch (delimitador) {
            case "\\t" -> "\t";
            default -> delimitador;
        };
    }
}

