/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.exportacaoconsultacsv;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.batch.exportacaoconsultacsv.ExportacaoConsultaCsvListener;
import br.com.elotech.tributos.batch.exportacaoconsultacsv.ExportacaoConsultaCsvReader;
import br.com.elotech.tributos.batch.exportacaoconsultacsv.ExportacaoConsultaCsvWriter;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaExportacaoRepository;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExportacaoConsultaCsvStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportacaoConsultaCsvStarter.class);
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final DataSource dataSource;
    private final StepBuilderFactory stepBuilderFactory;
    private final JdbcTemplate jdbcTemplate;
    private final JobBuilderFactory jobBuilderFactory;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final EntityManager entityManager;
    private final AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void startJob(List<String> views, String delimitador, Long idAgendamento, String descricaoAgendamento, String regexNomeArquivo) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        String viewsJoined = String.join((CharSequence)", ", views);
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.EXPORTACAO_CONSULTA_CSV.getTipo()).stream().anyMatch(jobExecution -> {
            String viewsParam = jobExecution.getJobParameters().getString("views");
            Long idAgendamentoParam = jobExecution.getJobParameters().getLong("idAgendamento");
            return StringUtils.equals((CharSequence)viewsParam, (CharSequence)viewsJoined) && Objects.equals(idAgendamentoParam, idAgendamento);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("J\u00e1 existe uma exporta\u00e7\u00e3o em processamento para as mesmas views %s e agendamento %d.", viewsJoined, idAgendamento));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addString("views", viewsJoined);
        jobParametersBuilder.addLong("idAgendamento", idAgendamento);
        jobParametersBuilder.addString("descricaoAgendamento", descricaoAgendamento);
        jobParametersBuilder.addString("regexNomeArquivo", regexNomeArquivo);
        jobParametersBuilder.addDate("date", new Date());
        this.jobLauncher.run(this.createJobs(views, delimitador), jobParametersBuilder.toJobParameters());
    }

    private Job createJobs(List<String> views, String delimitador) {
        List<Step> steps = views.stream().map(view -> this.createStep(view, "SELECT * FROM " + view, delimitador)).toList();
        FlowBuilder flowBuilder = new FlowBuilder("exportacaoConsultaCsv");
        flowBuilder.start(steps.get(0));
        for (int i = 1; i < steps.size(); ++i) {
            flowBuilder.next(steps.get(i));
        }
        Flow build = (Flow)flowBuilder.build();
        return ((FlowJobBuilder)this.jobBuilderFactory.get(JobType.EXPORTACAO_CONSULTA_CSV.getTipo()).start(build).end()).build();
    }

    private String[] getColumnNames(String sql) {
        return (String[])this.jdbcTemplate.execute(conn -> {
            try (PreparedStatement ps = conn.prepareStatement(sql + " WHERE 1=0");){
                ResultSetMetaData meta = ps.getMetaData();
                int count = meta.getColumnCount();
                String[] cols = new String[count];
                for (int i = 1; i <= count; ++i) {
                    cols[i - 1] = meta.getColumnName(i).toUpperCase();
                }
                String[] stringArray = cols;
                return stringArray;
            }
        });
    }

    private Step createStep(String viewName, String sql, String delimitador) {
        String[] columnNames = this.getColumnNames(sql);
        String filename = viewName + ".csv";
        String tempDir = System.getProperty("java.io.tmpdir") + File.separator;
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("step-" + viewName).chunk(5000).reader((ItemReader)new ExportacaoConsultaCsvReader(viewName, sql, this.dataSource)).writer((ItemWriter)new ExportacaoConsultaCsvWriter(viewName, filename, tempDir, delimitador, columnNames)).listener((StepExecutionListener)new ExportacaoConsultaCsvListener(filename, tempDir, this.arquivoStorageFeignClient, this.entityManager, this.agendamentoRotinaExportacaoRepository))).build();
    }

    @Generated
    public ExportacaoConsultaCsvStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, DataSource dataSource, StepBuilderFactory stepBuilderFactory, JdbcTemplate jdbcTemplate, JobBuilderFactory jobBuilderFactory, ArquivoStorageFeignClient arquivoStorageFeignClient, EntityManager entityManager, AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.dataSource = dataSource;
        this.stepBuilderFactory = stepBuilderFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.jobBuilderFactory = jobBuilderFactory;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.entityManager = entityManager;
        this.agendamentoRotinaExportacaoRepository = agendamentoRotinaExportacaoRepository;
    }
}

