/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.exportacaoconsultacsv;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotinaExportacao;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaExportacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.ByteMultipartFile;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.web.multipart.MultipartFile;

public class ExportacaoConsultaCsvListener
implements StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportacaoConsultaCsvListener.class);
    private final String filename;
    private final String targetDir;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final EntityManager entityManager;
    private final AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository;

    public void beforeStep(StepExecution stepExecution) {
        log.info(String.format("Iniciando a exporta\u00e7\u00e3o do arquivo %s para o diret\u00f3rio %s", this.filename, this.targetDir));
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info(String.format("Finalizando a exporta\u00e7\u00e3o do arquivo %s para o diret\u00f3rio %s", this.filename, this.targetDir));
        if (ExitStatus.COMPLETED.equals((Object)stepExecution.getExitStatus())) {
            try {
                String tempFilePath = this.targetDir + this.filename;
                Path tempFile = Paths.get(tempFilePath, new String[0]);
                ArquivoDTO arquivoDTO = this.uploadArquivoS3(tempFile, this.filename);
                Long idAgendamento = stepExecution.getJobParameters().getLong("idAgendamento");
                String regexNomeArquivo = stepExecution.getJobParameters().getString("regexNomeArquivo");
                AgendamentoRotinaExportacao exportacao = new AgendamentoRotinaExportacao();
                exportacao.setBatchJobExportacao(BatchJobExecution.of((JobExecution)stepExecution.getJobExecution()));
                exportacao.setDataExportacao(LocalDateTime.now());
                exportacao.setFullPath(arquivoDTO.getFullPath());
                exportacao.setIdArquivo(arquivoDTO.getId());
                exportacao.setNomeArquivo(Optional.ofNullable(regexNomeArquivo).map(reg -> arquivoDTO.getNome().replaceAll((String)reg, "$1")).orElse(arquivoDTO.getNome()));
                exportacao.setAgendamentoRotina((AgendamentoRotina)this.entityManager.getReference(AgendamentoRotina.class, (Object)idAgendamento));
                this.agendamentoRotinaExportacaoRepository.save((Object)exportacao);
                Files.deleteIfExists(tempFile);
            }
            catch (IOException e) {
                return ExitStatus.FAILED.addExitDescription("Erro ao fazer upload do arquivo para o S3: " + e.getMessage());
            }
        }
        return stepExecution.getExitStatus();
    }

    private ArquivoDTO uploadArquivoS3(Path tempFile, String nomeArquivo) throws IOException {
        try (InputStream fileStream = Files.newInputStream(tempFile, StandardOpenOption.READ);){
            ByteMultipartFile byteMultipartFile = new ByteMultipartFile(fileStream.readAllBytes(), "application/octet-stream");
            ArquivoDTO arquivoDTO = new ArquivoDTO(null, nomeArquivo, SecurityUtils.getUserId(), TipoArquivoEnum.ASYNC_GENERATED, Modulo.OXY_TRIBUTOS, "/exportacao-consulta-csv", LocalDate.now(), "application/octet-stream", null, null, null);
            ArquivoDTO arquivoDTO2 = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, (MultipartFile)byteMultipartFile);
            return arquivoDTO2;
        }
    }

    @Generated
    public ExportacaoConsultaCsvListener(String filename, String targetDir, ArquivoStorageFeignClient arquivoStorageFeignClient, EntityManager entityManager, AgendamentoRotinaExportacaoRepository agendamentoRotinaExportacaoRepository) {
        this.filename = filename;
        this.targetDir = targetDir;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.entityManager = entityManager;
        this.agendamentoRotinaExportacaoRepository = agendamentoRotinaExportacaoRepository;
    }
}

