/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.estornoatualizacaomonetaria;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.DebitosEstornoAtualizacaoDTO;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoAtualizacaoMonetariaParcelamentoBatchProcessor
implements ItemProcessor<DebitosEstornoAtualizacaoDTO, DebitosEstornoAtualizacaoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoAtualizacaoMonetariaParcelamentoBatchProcessor.class);
    private final DebitoParcelaTributoService debitoParcelaTributoService;

    public DebitosEstornoAtualizacaoDTO process(DebitosEstornoAtualizacaoDTO item) throws Exception {
        if (item.getValorAtualizacao().compareTo(BigDecimal.ZERO) == 0) {
            return item;
        }
        DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)this.debitoParcelaTributoService.findById((Serializable)item.getIdDebitoParcelaTributo()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar registro com o id %d", item.getIdDebitoParcelaTributo())));
        debitoParcelaTributo.setValor(debitoParcelaTributo.getValor().subtract(item.getValorAtualizacao()));
        debitoParcelaTributo.setValorAtualizacao(debitoParcelaTributo.getValorAtualizacao().subtract(item.getValorAtualizacao()));
        this.debitoParcelaTributoService.save((EloEntity)debitoParcelaTributo, null);
        return item;
    }

    @Generated
    public EstornoAtualizacaoMonetariaParcelamentoBatchProcessor(DebitoParcelaTributoService debitoParcelaTributoService) {
        this.debitoParcelaTributoService = debitoParcelaTributoService;
    }
}

