/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.enviopeticaoprocuradoria;

import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.service.documento.EnviarPeticaoService;
import br.com.elotech.tributos.service.exception.EnvioArquivoProcuradoriaException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EnvioPeticaoProcuradoriaBatchProcessor
implements ItemProcessor<Long, Documento> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvioPeticaoProcuradoriaBatchProcessor.class);
    private StepExecution stepExecution;
    private EnviarPeticaoService enviarPeticaoService;

    public EnvioPeticaoProcuradoriaBatchProcessor(EnviarPeticaoService enviarPeticaoService) {
        this.enviarPeticaoService = enviarPeticaoService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public Documento process(Long idPeticao) throws IOException {
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Executando gera\u00e7\u00e3o do arquivo agrupado de Peti\u00e7\u00e3o e CDAs para envio a Procuradoria. Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        try {
            return this.enviarPeticaoService.agruparArquivoPeticaoLoteCda(idPeticao);
        }
        catch (EnvioArquivoProcuradoriaException envioArquivoProcuradoriaException) {
            LOGGER.info("Peti\u00e7\u00e3o {} j\u00e1 est\u00e1 marcado como enviado para Procuradoria!", (Object)idPeticao);
            return null;
        }
    }
}

