/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.descontobaixaautomatica;

import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class DescontoBaixaAutomaticaDetalheReader
extends JpaPagingItemReader<BaixaAutomaticaDetalhe> {
    public DescontoBaixaAutomaticaDetalheReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        this.setPageSize(500);
        this.setName("concederDescontoBaixaAutomaticaId");
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString(this.getSql());
        Map<String, Object> params = Map.of("lote", jobParameters.get("lote"), "exercicio", jobParameters.get("exercicio"), "entidade", jobParameters.get("entidade"));
        this.setParameterValues(params);
    }

    private String getSql() {
        return " SELECT b  FROM BaixaAutomaticaDetalhe b   JOIN b.tipoMensagem tm  WHERE b.id.lote = :lote   AND b.id.exercicio = :exercicio   AND b.id.entidade = :entidade   AND tm.permiteConcederDesconto IS TRUE";
    }
}

